/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery;

import com.gendeathrow.hatchery.common.capability.CapabilityAnimalStatsHandler;
import com.gendeathrow.hatchery.core.Settings;
import com.gendeathrow.hatchery.core.config.ConfigHandler;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.core.proxies.CommonProxy;
import com.gendeathrow.hatchery.core.theoneprobe.TheOneProbeSupport;
import com.gendeathrow.hatchery.entities.EntityRooster;
import com.gendeathrow.hatchery.network.HatcheryPacket;
import com.gendeathrow.hatchery.network.HatcheryWindowPacket;
import java.io.IOException;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="hatchery", name="Hatchery", version="0.3.21", dependencies="after:chickens@[4.1,)", guiFactory="com.gendeathrow.hatchery.client.config.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class Hatchery {
    public static final String MODID = "hatchery";
    public static final String VERSION = "0.3.21";
    public static final String NAME = "Hatchery";
    private static final String PROXYLOC = "com.gendeathrow.hatchery.core.proxies";
    public static final String CHANNELNAME = "genhatchery";
    public static final String dependencies = "after:chickens@[4.1,)";
    @Mod.Instance(value="hatchery")
    public static Hatchery INSTANCE;
    @SidedProxy(clientSide="com.gendeathrow.hatchery.core.proxies.ClientProxy", serverSide="com.gendeathrow.hatchery.core.proxies.CommonProxy")
    public static CommonProxy PROXY;
    public static SimpleNetworkWrapper network;
    public static FMLEventChannel channel;
    public static Logger logger;
    static int startEntityId;
    public static CreativeTabs hatcheryTabs;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigHandler.INSTANCE.loadConfig(event);
        CapabilityAnimalStatsHandler.register();
        network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNELNAME);
        network.registerMessage(HatcheryPacket.ServerHandler.class, HatcheryPacket.class, 0, Side.SERVER);
        network.registerMessage(HatcheryPacket.ClientHandler.class, HatcheryPacket.class, 1, Side.CLIENT);
        network.registerMessage(HatcheryWindowPacket.ClientHandler.class, HatcheryWindowPacket.class, 2, Side.CLIENT);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)PROXY);
        EntityRegistry.registerModEntity(EntityRooster.class, (String)"Rooster", (int)1, (Object)this, (int)120, (int)1, (boolean)true);
        Hatchery.registerEntityEgg(EntityRooster.class, 5843968, 0xC10000);
        PROXY.registerRenderers();
        for (Biome allBiomes : ForgeRegistries.BIOMES.getValues()) {
            if (BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND) || BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) continue;
            EntityRegistry.addSpawn(EntityRooster.class, (int)Settings.ROOSTER_SPAWN_PROBABILITY, (int)Settings.ROOSTER_MIN_SPAWN_SIZE, (int)Settings.ROOSTER_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{allBiomes});
        }
        PROXY.preInit(event);
    }

    public static int getUniqueEntityId() {
        while (EntityList.func_90035_a((int)(++startEntityId)) != null) {
        }
        return startEntityId;
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int baseColor, int spotColor) {
        int id = Hatchery.getUniqueEntityId();
        EntityList.func_75618_a(entity, (String)"Rooster", (int)id);
        EntityList.field_75627_a.put("Rooster", new EntityList.EntityEggInfo("Rooster", baseColor, spotColor));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws IOException {
        PROXY.init(event);
        ConfigHandler.loadConfig();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.gendeathrow.hatchery.core.waila.HatcheryTileProvider.load");
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TheOneProbeSupport.register();
        }
        PROXY.registerEventHandlers();
        PROXY.initRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
    }

    static {
        startEntityId = 1;
        hatcheryTabs = new CreativeTabs(MODID){

            public Item func_78016_d() {
                return ModItems.hatcheryEgg;
            }
        };
        FluidRegistry.enableUniversalBucket();
    }
}

