/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUpgrade
extends ItemBase {
    public static final int TYPE_RANGE = 1;
    public static final int TYPE_SPEED = 2;
    public static final int TYPE_CRAFTING = 3;
    public static final int TYPE_STACK = 4;
    public static final int TYPE_INTERDIMENSIONAL = 5;
    public static final int TYPE_SILK_TOUCH = 6;
    public static final int TYPE_FORTUNE = 7;
    private static final String NBT_FORTUNE = "Fortune";

    public ItemUpgrade() {
        super("upgrade");
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77960_j() == 6 || stack.func_77960_j() == 7;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (stack.func_77952_i() == 7) {
            tooltip.add(I18n.func_135052_a((String)"enchantment.lootBonusDigger", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("enchantment.level." + ItemUpgrade.getFortuneLevel(stack)), (Object[])new Object[0]));
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i <= 6; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
        for (int j = 1; j <= 3; ++j) {
            list.add(ItemUpgrade.initializeForFortune(j));
        }
    }

    public static ItemStack initializeForFortune(int level) {
        ItemStack stack = new ItemStack((Item)RSItems.UPGRADE, 1, 7);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a(NBT_FORTUNE, level);
        return stack;
    }

    public static int getFortuneLevel(ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.func_77952_i() == 7 && (tag = stack.func_77978_p()).func_74764_b(NBT_FORTUNE)) {
            return tag.func_74762_e(NBT_FORTUNE);
        }
        return 0;
    }

    public static int getEnergyUsage(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 1: {
                return RS.INSTANCE.config.rangeUpgradeUsage;
            }
            case 2: {
                return RS.INSTANCE.config.speedUpgradeUsage;
            }
            case 3: {
                return RS.INSTANCE.config.craftingUpgradeUsage;
            }
            case 4: {
                return RS.INSTANCE.config.stackUpgradeUsage;
            }
            case 5: {
                return RS.INSTANCE.config.interdimensionalUpgradeUsage;
            }
            case 6: {
                return RS.INSTANCE.config.silkTouchUpgradeUsage;
            }
            case 7: {
                return RS.INSTANCE.config.fortuneUpgradeUsagePerFortune * ItemUpgrade.getFortuneLevel(stack);
            }
        }
        return 0;
    }

    public static ItemStack getRequirement(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 1: {
                return new ItemStack(Items.field_151079_bi);
            }
            case 2: {
                return new ItemStack(Items.field_151102_aT);
            }
            case 3: {
                return new ItemStack(Blocks.field_150462_ai);
            }
            case 5: {
                return new ItemStack(Items.field_151156_bN);
            }
            case 6: {
                return Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.func_180305_b((String)"silk_touch"), 1));
            }
            case 7: {
                return Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantment.func_180305_b((String)"fortune"), ItemUpgrade.getFortuneLevel(stack)));
            }
        }
        return null;
    }
}

