/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.filtering;

import com.raoulvdberge.refinedstorage.gui.grid.GridFilter;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterCraftable;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterFilteredItems;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterMod;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterName;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterOreDict;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterTooltip;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.tile.grid.IGrid;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public class GridFilterParser {
    public static List<Predicate<IGridStack>> getFilters(IGrid grid, String query, List<GridFilter> filteredItems) {
        LinkedList<Predicate<IGridStack>> filters = new LinkedList<Predicate<IGridStack>>();
        for (String part : query.toLowerCase().trim().split(" ")) {
            if (part.startsWith("@")) {
                filters.add(new GridFilterMod(part.substring(1)));
                continue;
            }
            if (part.startsWith("#")) {
                filters.add(new GridFilterTooltip(part.substring(1)));
                continue;
            }
            if (part.startsWith("$")) {
                filters.add(new GridFilterOreDict(part.substring(1)));
                continue;
            }
            filters.add(new GridFilterName(part));
        }
        if (grid.getViewType() == 1) {
            filters.add(new GridFilterCraftable(false));
        } else if (grid.getViewType() == 2) {
            filters.add(new GridFilterCraftable(true));
        }
        if (!filteredItems.isEmpty()) {
            filters.add(new GridFilterFilteredItems(filteredItems));
        }
        return filters;
    }
}

