/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.solderer;

import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRecipe;
import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SoldererRegistry
implements ISoldererRegistry {
    private List<ISoldererRecipe> recipes = new ArrayList<ISoldererRecipe>();

    @Override
    public void addRecipe(@Nonnull ISoldererRecipe recipe) {
        this.recipes.add(recipe);
    }

    @Override
    @Nullable
    public ISoldererRecipe getRecipe(@Nonnull IItemHandler rows) {
        for (ISoldererRecipe recipe : this.recipes) {
            boolean found = true;
            for (int i = 0; i < 3; ++i) {
                if (!API.instance().getComparer().isEqual(recipe.getRow(i), rows.getStackInSlot(i), 27)) {
                    found = false;
                }
                ItemStack row = recipe.getRow(i);
                if (rows.getStackInSlot(i) == null || row == null || rows.getStackInSlot((int)i).field_77994_a >= row.field_77994_a) continue;
                found = false;
            }
            if (!found) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<ISoldererRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    @Nonnull
    public ISoldererRecipe createSimpleRecipe(final @Nonnull ItemStack result, final int duration, final ItemStack ... rows) {
        if (rows.length != 3) {
            throw new IllegalArgumentException("Solderer recipe expects 3 rows, got " + rows.length + " rows");
        }
        return new ISoldererRecipe(){

            @Override
            @Nullable
            public ItemStack getRow(int row) {
                return rows[row];
            }

            @Override
            @Nonnull
            public ItemStack getResult() {
                return result;
            }

            @Override
            public int getDuration() {
                return duration;
            }
        };
    }

    @Override
    public List<ISoldererRecipe> removeRecipe(@Nonnull ItemStack result, ItemStack ... rows) {
        if (rows.length != 0 && rows.length != 3) {
            throw new IllegalArgumentException("Removing a recipe requires either no rows or 3 rows, got " + rows.length + " rows");
        }
        Iterator<ISoldererRecipe> itr = this.recipes.iterator();
        LinkedList<ISoldererRecipe> removed = new LinkedList<ISoldererRecipe>();
        while (itr.hasNext()) {
            ISoldererRecipe recipe = itr.next();
            if (!API.instance().getComparer().isEqualNoQuantity(result, recipe.getResult()) || rows.length != 0 && !this.compareRows(recipe, rows)) continue;
            itr.remove();
            removed.add(recipe);
        }
        return removed;
    }

    private boolean compareRows(ISoldererRecipe recipe, ItemStack[] rows) {
        for (int i = 0; i < 3; ++i) {
            if (API.instance().getComparer().isEqualNoQuantity(recipe.getRow(i), rows[i])) continue;
            return false;
        }
        return true;
    }
}

