/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepCraft;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStepProcess;
import com.raoulvdberge.refinedstorage.apiimpl.util.Comparer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public abstract class CraftingStep
implements ICraftingStep {
    public static final String NBT_CRAFTING_STEP_TYPE = "CraftingStepType";
    private static final String NBT_SATISFIED = "Satisfied_%d";
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_PATTERN_CONTAINER = "PatternContainer";
    private static final String NBT_STARTED_PROCESSING = "StartedProcessing";
    private static final String NBT_PRELIMINARY_STEPS = "PreliminarySteps";
    protected INetworkMaster network;
    protected ICraftingPattern pattern;
    protected Map<Integer, Integer> satisfied;
    protected boolean startedProcessing;
    protected List<ICraftingStep> preliminarySteps;

    public CraftingStep(INetworkMaster network, ICraftingPattern pattern, List<ICraftingStep> preliminarySteps) {
        this.network = network;
        this.pattern = pattern;
        this.satisfied = new HashMap<Integer, Integer>(this.getPattern().getOutputs().size());
        this.preliminarySteps = new ArrayList<ICraftingStep>(preliminarySteps);
    }

    public CraftingStep(INetworkMaster network) {
        this.network = network;
    }

    public boolean readFromNBT(NBTTagCompound tag) {
        TileEntity container;
        ItemStack patternStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(NBT_PATTERN));
        if (patternStack != null && (container = this.network.getNetworkWorld().func_175625_s(BlockPos.func_177969_a((long)tag.func_74763_f(NBT_PATTERN_CONTAINER)))) instanceof ICraftingPatternContainer) {
            this.pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.network.getNetworkWorld(), patternStack, (ICraftingPatternContainer)container);
            this.satisfied = new HashMap<Integer, Integer>(this.pattern.getOutputs().size());
            for (ItemStack stack : this.pattern.getOutputs()) {
                int hashcode = API.instance().getItemStackHashCode(stack);
                String id = String.format(NBT_SATISFIED, hashcode);
                if (!tag.func_74764_b(id)) continue;
                this.satisfied.put(hashcode, tag.func_74762_e(id));
            }
            this.startedProcessing = tag.func_74767_n(NBT_STARTED_PROCESSING);
            NBTTagList preliminaryTagList = tag.func_150295_c(NBT_PRELIMINARY_STEPS, 10);
            this.preliminarySteps = new LinkedList<ICraftingStep>();
            for (int i = 0; i < preliminaryTagList.func_74745_c(); ++i) {
                NBTTagCompound stepTag = preliminaryTagList.func_150305_b(i);
                ICraftingStep step = CraftingStep.toCraftingStep(stepTag, this.network);
                if (step == null) continue;
                this.preliminarySteps.add(step);
            }
            return true;
        }
        return false;
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public List<ItemStack> getToInsert() {
        return this.pattern.getInputs().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<ICraftingStep> getPreliminarySteps() {
        return this.preliminarySteps != null ? this.preliminarySteps : Collections.emptyList();
    }

    @Override
    public boolean canStartProcessing() {
        return this.getPreliminarySteps().size() == 0;
    }

    @Override
    public void setStartedProcessing() {
        this.startedProcessing = true;
    }

    @Override
    public boolean hasStartedProcessing() {
        return this.startedProcessing;
    }

    @Override
    public boolean hasReceivedOutputs() {
        for (ItemStack stack : this.pattern.getOutputs()) {
            Integer received = this.satisfied.get(API.instance().getItemStackHashCode(stack));
            if (received != null && stack.field_77994_a <= received) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasReceivedOutput(ItemStack stack) {
        Integer received = this.satisfied.get(API.instance().getItemStackHashCode(stack));
        return received != null && received >= stack.field_77994_a;
    }

    @Override
    public int getReceivedOutput(ItemStack stack) {
        Integer received = this.satisfied.get(API.instance().getItemStackHashCode(stack));
        return received == null ? 0 : received;
    }

    @Override
    public boolean onReceiveOutput(ItemStack stack) {
        ItemStack compareStack = Comparer.stripTags(stack.func_77946_l());
        for (ItemStack output : this.pattern.getOutputs()) {
            int hashcode = API.instance().getItemStackHashCode(output);
            Integer received = this.satisfied.get(hashcode);
            if (received == null) {
                received = 0;
            }
            if (!API.instance().getComparer().isEqual(compareStack, output, 0x13 | (this.getPattern().isOredict() ? 8 : 0)) || received >= output.field_77994_a) continue;
            int toReceive = Math.min(output.field_77994_a - received, stack.field_77994_a);
            this.satisfied.put(hashcode, received + toReceive);
            stack.field_77994_a -= toReceive;
            this.network.markCraftingMonitorForUpdate();
            if (stack.field_77994_a != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        for (Map.Entry<Integer, Integer> entry : this.satisfied.entrySet()) {
            tag.func_74768_a(String.format(NBT_SATISFIED, entry.getKey()), entry.getValue().intValue());
        }
        tag.func_74782_a(NBT_PATTERN, (NBTBase)this.pattern.getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER, this.pattern.getContainer().getPosition().func_177986_g());
        tag.func_74757_a(NBT_STARTED_PROCESSING, this.startedProcessing);
        NBTTagList preliminaryTagList = new NBTTagList();
        for (ICraftingStep step : this.preliminarySteps) {
            preliminaryTagList.func_74742_a((NBTBase)step.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_PRELIMINARY_STEPS, (NBTBase)preliminaryTagList);
        return tag;
    }

    protected AvailableType isItemAvailable(IItemStackList items, IFluidStackList fluids, ItemStack stack, ItemStack actualStack, int compare) {
        if (actualStack == null || actualStack.field_77994_a == 0 || !items.trackedRemove(actualStack, stack.field_77994_a, true)) {
            FluidStack fluidInItem = RSUtils.getFluidFromStack(stack, true);
            if (fluidInItem != null && RSUtils.hasFluidBucket(fluidInItem)) {
                FluidStack fluidStack = fluids.get(fluidInItem, compare);
                ItemStack bucket = items.get(RSUtils.EMPTY_BUCKET, compare);
                if (bucket != null && fluidStack != null && fluids.trackedRemove(fluidStack, fluidInItem.amount, true) && items.trackedRemove(bucket, 1, true)) {
                    return AvailableType.FLUID;
                }
            }
            return null;
        }
        return AvailableType.ITEM;
    }

    protected boolean extractItems(List<ItemStack> actualInputs, int compare, Deque<ItemStack> toInsertItems) {
        for (ItemStack insertStack : this.getToInsert()) {
            compare = insertStack.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
            ItemStack input = this.network.extractItem(insertStack, insertStack.field_77994_a, compare, false);
            if (input != null) {
                actualInputs.add(input);
                continue;
            }
            boolean abort = true;
            FluidStack fluidInItem = RSUtils.getFluidFromStack(insertStack, true);
            if (fluidInItem != null) {
                FluidStack fluidStack = this.network.extractFluid(fluidInItem, fluidInItem.amount, compare, false);
                ItemStack bucketStack = this.network.extractItem(RSUtils.EMPTY_BUCKET, 1, compare, false);
                if (fluidStack != null && fluidStack.amount == fluidInItem.amount && bucketStack != null) {
                    abort = false;
                    actualInputs.add(insertStack.func_77946_l());
                }
            }
            if (!abort) continue;
            toInsertItems.addAll(actualInputs);
            this.startedProcessing = false;
            return false;
        }
        return true;
    }

    public static ICraftingStep toCraftingStep(NBTTagCompound compound, INetworkMaster network) {
        CraftingStep step = null;
        switch (compound.func_74779_i(NBT_CRAFTING_STEP_TYPE)) {
            case "craft": {
                step = new CraftingStepCraft(network);
                break;
            }
            case "process": {
                step = new CraftingStepProcess(network);
            }
        }
        if (step != null && ((CraftingStep)step).readFromNBT(compound)) {
            return step;
        }
        return null;
    }

    static enum AvailableType {
        ITEM,
        FLUID;

    }
}

