/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.terrain;

import eladkay.scanner.Config;
import eladkay.scanner.compat.Oregistry;
import eladkay.scanner.misc.BaseTE;
import eladkay.scanner.misc.WtfException;
import eladkay.scanner.terrain.BlockDimensionalCore;
import eladkay.scanner.terrain.EnumDimensions;
import eladkay.scanner.terrain.EnumRotation;
import eladkay.scanner.terrain.TileEntityScannerQueue;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityTerrainScanner
extends BaseTE
implements ITickable {
    public static final String PRESET = "{\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"depthNoiseScaleExponent\":0.5,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"seaLevel\":63,\"useCaves\":true,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useMineShafts\":true,\"useTemples\":true,\"useMonuments\":true,\"useRavines\":true,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useLavaOceans\":false,\"fixedBiome\":-1,\"biomeSize\":4,\"riverSize\":4,\"dirtSize\":33,\"dirtCount\":10,\"dirtMinHeight\":0,\"dirtMaxHeight\":256,\"gravelSize\":33,\"gravelCount\":8,\"gravelMinHeight\":0,\"gravelMaxHeight\":256,\"graniteSize\":33,\"graniteCount\":10,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":10,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":10,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16}";
    private static final int MAX = Config.maxEnergyBufferTerrain;
    TileEntityScannerQueue queue;
    boolean on;
    BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos(0, -1, 0);
    public EnumRotation rotation = EnumRotation.POSX_POSZ;
    public int speedup = 1;
    public BlockPos posStart = null;
    public int maxY = 127;

    @Nonnull
    public BlockPos getPosStart() {
        return this.posStart != null ? this.posStart : this.func_174877_v();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.current.func_189533_g((Vec3i)BlockPos.func_177969_a((long)nbt.func_74763_f("positions")));
        this.on = nbt.func_74767_n("on");
        this.rotation = EnumRotation.values()[nbt.func_74762_e("rot")];
        this.speedup = nbt.func_74762_e("speedup");
        if (nbt.func_74763_f("posStart") != 0L) {
            this.posStart = BlockPos.func_177969_a((long)nbt.func_74763_f("posStart"));
        }
        this.maxY = nbt.func_74762_e("my");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("positions", this.current.func_177986_g());
        nbt.func_74757_a("on", this.on);
        nbt.func_74768_a("rot", this.rotation.ordinal());
        nbt.func_74768_a("speedup", this.speedup);
        if (this.posStart != null) {
            nbt.func_74772_a("posStart", this.posStart.func_177986_g());
        }
        nbt.func_74768_a("my", this.maxY);
        return nbt;
    }

    public TileEntityTerrainScanner() {
        super(MAX);
    }

    public void onBlockActivated() {
        if (this.current.func_177956_o() < 0) {
            this.current.func_181079_c(this.func_174877_v().func_177958_n() + 1, 0, this.func_174877_v().func_177952_p());
            this.changeState(true);
        }
    }

    public void activate() {
        this.changeState(true);
        this.current.func_181079_c(this.getPosStart().func_177958_n() + 1, 0, this.getPosStart().func_177952_p());
    }

    public void deactivate() {
        this.changeState(false);
    }

    @Nonnull
    BlockPos getEnd() {
        return this.getPosStart().func_177982_a(15, this.maxY, 15);
    }

    void changeState(boolean state) {
        this.on = state;
        this.func_70296_d();
    }

    public void func_73660_a() {
        WorldServer remoteWorld;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.queue = TileEntityScannerQueue.getNearbyQueue(this.func_145831_w(), this);
        EnumDimensions type = this.func_145831_w().field_73011_w.getDimension() == -1 ? EnumDimensions.NETHER : (this.func_145831_w().field_73011_w.getDimension() == 1 ? EnumDimensions.END : EnumDimensions.OVERWORLD);
        for (EnumFacing facing : EnumFacing.values()) {
            IBlockState te = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(facing));
            if (!(te.func_177230_c() instanceof BlockDimensionalCore) || te.func_177229_b(BlockDimensionalCore.TYPE) == EnumDimensions.NONE) continue;
            type = (EnumDimensions)((Object)te.func_177229_b(BlockDimensionalCore.TYPE));
        }
        try {
            remoteWorld = type == EnumDimensions.NETHER ? FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(Config.dimid + 1) : (type == EnumDimensions.END ? FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(Config.dimid + 2) : FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(Config.dimid));
        }
        catch (NullPointerException lazy) {
            return;
        }
        if (this.func_145831_w().func_175640_z(this.func_174877_v())) {
            this.on = true;
        }
        int multiplier = 0;
        for (int j = 0; j < this.speedup; ++j) {
            if (!this.on) {
                return;
            }
            if (this.container().getEnergyStored() < Config.energyPerBlockTerrainScanner) {
                return;
            }
            this.changeState(true);
            remoteWorld.func_180495_p((BlockPos)this.current);
            IBlockState remote = remoteWorld.func_180495_p((BlockPos)this.current);
            IBlockState local = this.func_145831_w().func_180495_p((BlockPos)this.current);
            TileEntity remoteTE = remoteWorld.func_175625_s((BlockPos)this.current);
            BlockPos imm = this.current.func_185334_h();
            if (local.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), imm) || local.func_177230_c().isAir(local, (IBlockAccess)this.func_145831_w(), imm)) {
                this.func_145831_w().func_180501_a(imm, remote, 2);
                if (remoteTE != null) {
                    NBTTagCompound tag = new NBTTagCompound();
                    remoteTE.func_189515_b(tag);
                    this.func_145831_w().func_175625_s(imm).func_189515_b(tag);
                }
                if (!remote.func_177230_c().isAir(remote, (IBlockAccess)this.func_145831_w(), imm)) {
                    ++multiplier;
                }
            }
            if (Config.genVanillaOres && this.func_145831_w().func_180495_p((BlockPos)this.current).func_177230_c() == Blocks.field_150348_b) {
                int i;
                if (this.current.func_177956_o() > 8) {
                    int i2 = ThreadLocalRandom.current().nextInt(25);
                    if (i2 == 0) {
                        this.func_145831_w().func_180501_a((BlockPos)this.current, Blocks.field_150365_q.func_176223_P(), 2);
                    } else if (i2 == 1) {
                        this.func_145831_w().func_180501_a((BlockPos)this.current, Blocks.field_150366_p.func_176223_P(), 2);
                    }
                }
                if (this.current.func_177956_o() > 8 && this.current.func_177956_o() < 16) {
                    int i3 = ThreadLocalRandom.current().nextInt(150);
                    if (i3 == 0) {
                        this.func_145831_w().func_180501_a((BlockPos)this.current, Blocks.field_150482_ag.func_176223_P(), 2);
                    } else if (i3 == 1) {
                        this.func_145831_w().func_180501_a((BlockPos)this.current, Blocks.field_150412_bA.func_176223_P(), 2);
                    } else if (i3 == 2) {
                        this.func_145831_w().func_180501_a((BlockPos)this.current, Blocks.field_150450_ax.func_176223_P(), 2);
                    } else if (i3 == 3) {
                        this.func_145831_w().func_180501_a((BlockPos)this.current, Blocks.field_150369_x.func_176223_P(), 2);
                    }
                }
                if (this.current.func_177956_o() > 8 && this.current.func_177956_o() < 32 && (i = ThreadLocalRandom.current().nextInt(45)) == 0) {
                    this.func_145831_w().func_180501_a((BlockPos)this.current, Blocks.field_150352_o.func_176223_P(), 2);
                }
            }
            Oregistry.getEntryList().stream().filter(entry -> this.current.func_177956_o() < entry.maxY && this.current.func_177956_o() > entry.minY).forEach(entry -> {
                int i = ThreadLocalRandom.current().nextInt(entry.rarity);
                if (i == 0) {
                    this.func_145831_w().func_180501_a((BlockPos)this.current, entry.ore, 2);
                }
            });
            if (this.rotation.x > 0) {
                this.current = new BlockPos.MutableBlockPos(this.current.func_177974_f());
            } else {
                new BlockPos.MutableBlockPos(this.current.func_177976_e());
            }
            BlockPos end = this.getEnd();
            if (this.current.func_177958_n() > end.func_177958_n()) {
                this.current = this.rotation == EnumRotation.NEGX_POSZ || this.rotation == EnumRotation.POSX_POSZ ? new BlockPos.MutableBlockPos(this.current.func_177968_d()) : new BlockPos.MutableBlockPos(this.current.func_177978_c());
                this.current.func_181079_c(this.getPosStart().func_177958_n(), this.current.func_177956_o(), this.current.func_177952_p());
            }
            if (this.current.func_177952_p() > end.func_177952_p() && this.rotation.z > 0 || this.current.func_177952_p() < end.func_177952_p() && this.rotation.z < 0) {
                this.current.func_181079_c(this.getPosStart().func_177958_n(), this.current.func_177956_o() + 1, this.getPosStart().func_177952_p());
            }
            if (this.current.func_177956_o() > this.maxY) {
                if (this.queue != null && this.queue.queue.peek() != null) {
                    BlockPos pos = this.queue.pop();
                    if (pos == null) {
                        throw new WtfException("How can this be???");
                    }
                    this.current.func_189533_g((Vec3i)pos);
                    this.posStart = pos;
                } else {
                    this.changeState(false);
                }
            }
            this.func_70296_d();
        }
        this.container().extractEnergy(Config.energyPerBlockTerrainScanner * multiplier, false);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }
}

