/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.misc;

import cofh.api.energy.IEnergyReceiver;
import eladkay.scanner.misc.BaseEnergyContainer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class BaseTE
extends TileEntity
implements IEnergyReceiver {
    private BaseEnergyContainer container;
    private int max;

    public BaseTE(int max) {
        this.max = max;
        this.container = max != 0 ? new BaseEnergyContainer(max, max) : null;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.max = nbt.func_74762_e("max");
        if (this.max != 0) {
            this.container = new BaseEnergyContainer(this.max, this.max);
            this.container.deserializeNBT(nbt.func_74775_l("TeslaContainer"));
        } else {
            this.container = null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("max", this.max);
        if (this.container != null) {
            nbt.func_74782_a("TeslaContainer", (NBTBase)this.container.serializeNBT());
        }
        return nbt;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.container == null) {
            return 0;
        }
        int energyReceived = Math.min(this.max - this.container.getEnergyStored(), maxReceive);
        if (!simulate) {
            energyReceived = this.container.receiveEnergy(energyReceived, false);
            this.func_70296_d();
        }
        return energyReceived;
    }

    public BaseEnergyContainer container() {
        if (this.shouldHaveContainer()) {
            if (this.container == null) {
                this.container = new BaseEnergyContainer(this.max);
                return this.container;
            }
            return this.container;
        }
        return null;
    }

    protected boolean shouldHaveContainer() {
        return this.max > 0;
    }

    public int getEnergyStored(EnumFacing from) {
        if (this.container == null) {
            return 0;
        }
        return this.container.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.max;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        SPacketUpdateTileEntity packer = new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
        return packer;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.container == null ? super.hasCapability(capability, facing) : capability == CapabilityEnergy.ENERGY || capability == BaseEnergyContainer.CAPABILITY_CONSUMER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY || capability == BaseEnergyContainer.CAPABILITY_CONSUMER ? (this.container != null ? this.container : super.getCapability(capability, facing)) : super.getCapability(capability, facing));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

