/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.biome;

import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.google.gson.Gson;
import eladkay.scanner.Config;
import eladkay.scanner.ScannerMod;
import eladkay.scanner.misc.BaseTE;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public class TileEntityBiomeScanner
extends BaseTE
implements ITickable {
    public HashMap<ChunkPos, String> mapping = new HashMap();
    public int type;

    public TileEntityBiomeScanner() {
        super(Config.maxEnergyBufferBiome);
    }

    private static String serialize(ChunkPos pos) {
        return pos.field_77276_a + "/" + pos.field_77275_b;
    }

    public static ChunkPos deserialize(String s) {
        String[] split = s.split("/");
        return new ChunkPos(Integer.valueOf(split[0]).intValue(), Integer.valueOf(split[1]).intValue());
    }

    public void onBlockActivated(EntityPlayer player) {
        ScannerMod.proxy.openGuiBiomeScanner(this);
    }

    public String toJson() {
        Gson gson = new Gson();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<ChunkPos, String> entry : this.mapping.entrySet()) {
            ret.put(TileEntityBiomeScanner.serialize(entry.getKey()), entry.getValue());
        }
        return gson.toJson(ret);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        Gson gson = new Gson();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<ChunkPos, String> entry : this.mapping.entrySet()) {
            ret.put(TileEntityBiomeScanner.serialize(entry.getKey()), entry.getValue());
        }
        String json = gson.toJson(ret);
        compound.func_74778_a("json", json);
        compound.func_74768_a("type", this.type);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        Gson gson = new Gson();
        HashMap ret = (HashMap)gson.fromJson(compound.func_74779_i("json"), HashMap.class);
        for (Map.Entry entry : ret.entrySet()) {
            this.mapping.put(TileEntityBiomeScanner.deserialize((String)entry.getKey()), (String)entry.getValue());
        }
        this.type = compound.func_74762_e("type");
        super.func_145839_a(compound);
    }

    @Nullable
    public String getMapping(int chunkX, int chunkY) {
        for (Map.Entry<ChunkPos, String> entry : this.mapping.entrySet()) {
            if (entry.getKey().field_77276_a != chunkX || entry.getKey().field_77275_b != chunkY) continue;
            return entry.getValue();
        }
        return null;
    }

    public void func_73660_a() {
        Block block = this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c();
        this.type = block == ScannerMod.biomeScannerBasic ? 0 : (block == ScannerMod.biomeScannerAdv ? 1 : (block == ScannerMod.biomeScannerElite ? 2 : 3));
    }

    public int getDist(ChunkPos chunkPos) {
        double d0 = this.field_174879_c.func_177958_n() - MathUtils.unchunk((int)chunkPos.field_77276_a);
        double d1 = this.field_174879_c.func_177952_p() - MathUtils.unchunk((int)chunkPos.field_77275_b);
        return (int)((double)MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) / 16.0);
    }
}

