/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner;

import eladkay.scanner.Config;
import eladkay.scanner.biome.BlockBiomeScanner;
import eladkay.scanner.biome.TileEntityBiomeScanner;
import eladkay.scanner.compat.MineTweaker;
import eladkay.scanner.misc.NetworkHelper;
import eladkay.scanner.proxy.CommonProxy;
import eladkay.scanner.terrain.BlockAirey;
import eladkay.scanner.terrain.BlockDimensionalCore;
import eladkay.scanner.terrain.BlockScannerQueue;
import eladkay.scanner.terrain.BlockTerrainScanner;
import eladkay.scanner.terrain.EnumDimensions;
import eladkay.scanner.terrain.TileEntityScannerQueue;
import eladkay.scanner.terrain.TileEntityTerrainScanner;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.ChunkProviderOverworld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

@Mod(modid="scanner", name="Scanner", version="1.4.1", acceptedMinecraftVersions="[1.10.2]")
public class ScannerMod {
    public static final String MODID = "scanner";
    private static final boolean TESTING = false;
    @SidedProxy(serverSide="eladkay.scanner.proxy.CommonProxy", clientSide="eladkay.scanner.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static DimensionType dimOverWorld;
    public static DimensionType dimNether;
    public static DimensionType dimEnd;
    public static BlockTerrainScanner terrainScanner;
    public static BlockScannerQueue scannerQueue;
    public static BlockBiomeScanner biomeScannerBasic;
    public static BlockBiomeScanner biomeScannerAdv;
    public static BlockBiomeScanner biomeScannerElite;
    public static BlockBiomeScanner biomeScannerUltimate;
    public static BlockDimensionalCore dimensionalCore;
    @Mod.Instance(value="scanner")
    public static ScannerMod instance;
    public static CreativeTabs tab;
    public static BlockAirey air;
    public static final String VERSION = "1.4.1";

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        instance = this;
        tab = new CreativeTabs(MODID){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)terrainScanner);
            }
        };
        air = new BlockAirey();
        GameRegistry.register((IForgeRegistryEntry)air);
        terrainScanner = new BlockTerrainScanner();
        GameRegistry.register((IForgeRegistryEntry)terrainScanner);
        GameRegistry.register((IForgeRegistryEntry)((Item)new ItemBlock(terrainScanner){

            public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add("The ultimate terrain reconstruction tool.");
                tooltip.add("Its GUI is fairly self-explanatory in my opinion.");
                super.func_77624_a(stack, playerIn, tooltip, advanced);
            }
        }.setRegistryName("scanner:terrainScanner")).func_77637_a(tab));
        GameRegistry.registerTileEntity(TileEntityTerrainScanner.class, (String)"terrainScanner");
        scannerQueue = new BlockScannerQueue();
        GameRegistry.register((IForgeRegistryEntry)scannerQueue);
        GameRegistry.register((IForgeRegistryEntry)((Item)new ItemBlock(scannerQueue){

            public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add("Provides a buffer of chunks and allows you to queue up chunks for scanning.");
                tooltip.add("Place next to Terrain Scanner.");
                super.func_77624_a(stack, playerIn, tooltip, advanced);
            }
        }.setRegistryName("scanner:scannerQueue")).func_77637_a(tab));
        GameRegistry.registerTileEntity(TileEntityScannerQueue.class, (String)"q");
        dimensionalCore = new BlockDimensionalCore();
        GameRegistry.register((IForgeRegistryEntry)dimensionalCore);
        GameRegistry.register((IForgeRegistryEntry)((Item)new ItemBlock(dimensionalCore){

            public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                if (stack.func_77952_i() == EnumDimensions.NONE.ordinal()) {
                    tooltip.add("Crafting component.");
                } else {
                    tooltip.add("Allows you to build chunks from other dimensions. ");
                    tooltip.add("Place next to Terrain Scanner.");
                }
                super.func_77624_a(stack, playerIn, tooltip, advanced);
            }

            public String func_77667_c(ItemStack stack) {
                return super.func_77667_c(stack) + "_" + EnumDimensions.values()[stack.func_77960_j()].func_176610_l();
            }

            public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
                IBlockState iblockstate = worldIn.func_180495_p(pos);
                Block block = iblockstate.func_177230_c();
                if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
                    pos = pos.func_177972_a(facing);
                }
                if (stack.field_77994_a != 0 && playerIn.func_175151_a(pos, facing, stack) && worldIn.func_175716_a(this.field_150939_a, pos, false, facing, null, stack)) {
                    int i = stack.func_77960_j();
                    IBlockState iblockstate1 = this.field_150939_a.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)playerIn, stack);
                    if (this.placeBlockAt(stack, playerIn, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                        SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)playerIn);
                        worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                        --stack.field_77994_a;
                    }
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
        }.func_77627_a(true).setRegistryName("scanner:dimensionalCore")).func_77637_a(tab));
        GameRegistry.registerTileEntity(TileEntityBiomeScanner.class, (String)"biomeScanner");
        biomeScannerBasic = (BlockBiomeScanner)new BlockBiomeScanner(0).setRegistryName("scanner:biomeScannerBasic");
        GameRegistry.register((IForgeRegistryEntry)biomeScannerBasic);
        GameRegistry.register((IForgeRegistryEntry)((Item)new ItemBlock(biomeScannerBasic){

            public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add("Provides info about biomes far away.");
                super.func_77624_a(stack, playerIn, tooltip, advanced);
            }
        }.setRegistryName("scanner:biomeScannerBasic")).func_77637_a(tab));
        biomeScannerAdv = (BlockBiomeScanner)new BlockBiomeScanner(1).setRegistryName("scanner:biomeScannerAdv");
        GameRegistry.register((IForgeRegistryEntry)biomeScannerAdv);
        GameRegistry.register((IForgeRegistryEntry)((Item)new ItemBlock(biomeScannerAdv){

            public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add("Provides info about biomes far away.");
                super.func_77624_a(stack, playerIn, tooltip, advanced);
            }
        }.setRegistryName("scanner:biomeScannerAdv")).func_77637_a(tab));
        biomeScannerElite = (BlockBiomeScanner)new BlockBiomeScanner(2).setRegistryName("scanner:biomeScannerElite");
        GameRegistry.register((IForgeRegistryEntry)biomeScannerElite);
        GameRegistry.register((IForgeRegistryEntry)((Item)new ItemBlock(biomeScannerElite){

            public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add("Provides info about biomes far away.");
                super.func_77624_a(stack, playerIn, tooltip, advanced);
            }
        }.setRegistryName("scanner:biomeScannerElite")).func_77637_a(tab));
        biomeScannerUltimate = (BlockBiomeScanner)new BlockBiomeScanner(3).setRegistryName("scanner:biomeScannerUltimate");
        GameRegistry.register((IForgeRegistryEntry)biomeScannerUltimate);
        GameRegistry.register((IForgeRegistryEntry)((Item)new ItemBlock(biomeScannerUltimate){

            public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add("Provides info about biomes far away.");
                super.func_77624_a(stack, playerIn, tooltip, advanced);
            }
        }.setRegistryName("scanner:biomeScannerUltimate")).func_77637_a(tab));
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"eladkay.scanner.compat.Waila.onWailaCall");
        MineTweaker.init();
        proxy.init();
        Config.initConfig(event.getSuggestedConfigurationFile());
        dimOverWorld = DimensionType.register((String)"fakeoverworld", (String)"", (int)Config.dimid, WorldProviderOverworld.class, (boolean)true);
        DimensionManager.registerDimension((int)Config.dimid, (DimensionType)dimOverWorld);
        dimNether = DimensionType.register((String)"fakenether", (String)"", (int)(Config.dimid + 1), WorldProviderNether.class, (boolean)true);
        DimensionManager.registerDimension((int)(Config.dimid + 1), (DimensionType)dimNether);
        dimEnd = DimensionType.register((String)"fakeend", (String)"", (int)(Config.dimid + 2), WorldProviderEnd.class, (boolean)true);
        DimensionManager.registerDimension((int)(Config.dimid + 2), (DimensionType)dimEnd);
        NetworkHelper.init();
    }

    @Mod.EventHandler
    public void fmlLifeCycle(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new SpeedTickCommand());
        event.registerServerCommand((ICommand)new TpToDim99Command());
    }

    public static class TpToDim99Command
    extends CommandBase {
        public String func_71517_b() {
            return "goto";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/goto";
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70005_c_().matches("(?:Player\\d{1,3})|(?:Eladk[ae]y)");
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length != 1) {
                return;
            }
            if ("homepls".equals(args[0])) {
                TpToDim99Command.func_71521_c((ICommandSender)sender).func_184204_a(0);
            } else if (args[0].contains("offwego")) {
                TpToDim99Command.func_71521_c((ICommandSender)sender).func_184204_a(Integer.parseInt(args[0].replace("offwego", "")));
            }
        }
    }

    public static class SpeedTickCommand
    extends CommandBase {
        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70005_c_().matches("(?:Player\\d{1,3})|(?:Eladk[ae]y)");
        }

        public String func_71517_b() {
            return "speedts";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/speedts";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            TileEntity te = server.func_71218_a(SpeedTickCommand.func_71521_c((ICommandSender)sender).field_71093_bK).func_175625_s(SpeedTickCommand.func_71521_c((ICommandSender)sender).func_180425_c().func_177977_b());
            if (te instanceof ITickable) {
                for (int i = 0; i < 100000; ++i) {
                    ((ITickable)te).func_73660_a();
                }
            }
        }
    }

    public static class WorldProviderEnd
    extends WorldProvider {
        public DimensionType func_186058_p() {
            return dimEnd;
        }

        public IChunkGenerator func_186060_c() {
            return new ChunkProviderEnd(this.field_76579_a, this.field_76579_a.func_72912_H().func_76089_r(), this.field_76579_a.func_72905_C());
        }
    }

    public static class WorldProviderNether
    extends WorldProvider {
        public DimensionType func_186058_p() {
            return dimNether;
        }

        public IChunkGenerator func_186060_c() {
            return new ChunkProviderHell(this.field_76579_a, this.field_76579_a.func_72912_H().func_76089_r(), this.field_76579_a.func_72905_C());
        }
    }

    public static class WorldProviderOverworld
    extends WorldProvider {
        public DimensionType func_186058_p() {
            return dimOverWorld;
        }

        public IChunkGenerator func_186060_c() {
            return new ChunkProviderOverworld(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r(), "{\"coordinateScale\":684.412,\"heightScale\":684.412,\"lowerLimitScale\":512.0,\"upperLimitScale\":512.0,\"depthNoiseScaleX\":200.0,\"depthNoiseScaleZ\":200.0,\"depthNoiseScaleExponent\":0.5,\"mainNoiseScaleX\":80.0,\"mainNoiseScaleY\":160.0,\"mainNoiseScaleZ\":80.0,\"baseSize\":8.5,\"stretchY\":12.0,\"biomeDepthWeight\":1.0,\"biomeDepthOffset\":0.0,\"biomeScaleWeight\":1.0,\"biomeScaleOffset\":0.0,\"seaLevel\":63,\"useCaves\":true,\"useDungeons\":true,\"dungeonChance\":8,\"useStrongholds\":true,\"useVillages\":true,\"useMineShafts\":true,\"useTemples\":true,\"useMonuments\":true,\"useRavines\":true,\"useWaterLakes\":true,\"waterLakeChance\":4,\"useLavaLakes\":true,\"lavaLakeChance\":80,\"useLavaOceans\":false,\"fixedBiome\":-1,\"biomeSize\":4,\"riverSize\":4,\"dirtSize\":33,\"dirtCount\":10,\"dirtMinHeight\":0,\"dirtMaxHeight\":256,\"gravelSize\":33,\"gravelCount\":8,\"gravelMinHeight\":0,\"gravelMaxHeight\":256,\"graniteSize\":33,\"graniteCount\":10,\"graniteMinHeight\":0,\"graniteMaxHeight\":80,\"dioriteSize\":33,\"dioriteCount\":10,\"dioriteMinHeight\":0,\"dioriteMaxHeight\":80,\"andesiteSize\":33,\"andesiteCount\":10,\"andesiteMinHeight\":0,\"andesiteMaxHeight\":80,\"coalSize\":17,\"coalCount\":20,\"coalMinHeight\":0,\"coalMaxHeight\":128,\"ironSize\":9,\"ironCount\":20,\"ironMinHeight\":0,\"ironMaxHeight\":64,\"goldSize\":9,\"goldCount\":2,\"goldMinHeight\":0,\"goldMaxHeight\":32,\"redstoneSize\":8,\"redstoneCount\":8,\"redstoneMinHeight\":0,\"redstoneMaxHeight\":16,\"diamondSize\":8,\"diamondCount\":1,\"diamondMinHeight\":0,\"diamondMaxHeight\":16,\"lapisSize\":7,\"lapisCount\":1,\"lapisCenterHeight\":16,\"lapisSpread\":16}");
        }
    }
}

