/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.util.helpers;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class InventoryRenderHelper {
    private final String domain;

    public InventoryRenderHelper(String domain) {
        this.domain = domain;
    }

    public void itemRender(Item item, int meta, String name) {
        String resName = this.domain + name;
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(resName)});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(resName, "inventory"));
    }

    public void itemRender(Item item, int meta) {
        this.itemRender(item, meta, InventoryRenderHelper.getClassName(item) + meta);
    }

    public void itemRender(Item item, String name) {
        this.itemRender(item, 0, name);
    }

    public void itemRender(Item item) {
        this.itemRender(item, 0, InventoryRenderHelper.getClassName(item));
    }

    public void itemRenderAll(Item item) {
        final Item toRender = item;
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return new ModelResourceLocation(InventoryRenderHelper.this.domain + InventoryRenderHelper.getClassName(toRender), "inventory");
            }
        });
    }

    public static Item getItemFromBlock(Block block) {
        return Item.func_150898_a((Block)block);
    }

    private static String getClassName(Item item) {
        return item instanceof ItemBlock ? Block.func_149634_a((Item)item).getClass().getSimpleName() : item.getClass().getSimpleName();
    }
}

