/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.registry;

import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IBackpack;
import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.ITieredBackpack;
import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IUpgradableBackpack;
import gr8pefish.ironbackpacks.api.register.IAllRecipesRegistry;
import gr8pefish.ironbackpacks.api.register.ItemIBackpackRegistry;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.crafting.BackpackAddUpgradeRecipe;
import gr8pefish.ironbackpacks.crafting.BackpackIncreaseTierRecipe;
import gr8pefish.ironbackpacks.crafting.BackpackRemoveUpgradeRecipe;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.libs.recipes.ItemBackpackRecipes;
import gr8pefish.ironbackpacks.libs.recipes.ItemCraftingRecipes;
import gr8pefish.ironbackpacks.libs.recipes.ItemUpgradeRecipes;
import gr8pefish.ironbackpacks.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;

public class RecipeRegistry {
    public static void registerAllRecipes() {
        ItemCraftingRecipes.registerItemCraftingRecipes();
        ItemUpgradeRecipes.registerItemUpgradeRecipes();
        ItemBackpackRecipes.registerItemBackpackRecipes();
        RecipeSorter.register((String)"RemoveUpgrade", BackpackRemoveUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"AddUpgrade", BackpackAddUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"IncreaseBackpackTier", BackpackIncreaseTierRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeRegistry.registerBackpackTierRecipes();
        RecipeRegistry.registerBackpackUpgradeRemovalRecipes();
        RecipeRegistry.registerBackpackUpgradeAdditionRecipes();
    }

    public static void setAllNonTierRecipes() {
        RecipeRegistry.setItemBackpackRecipes();
        RecipeRegistry.setUpgradeRecipes();
    }

    private static void setItemBackpackRecipes() {
        ItemRegistry.basicBackpack.setItemRecipe((IRecipe)ItemBackpackRecipes.basicBackpackRecipe);
    }

    private static void setUpgradeRecipes() {
        if (!ConfigHandler.additionalUpgradePointsRecipeDisabled) {
            ItemRegistry.additionalUpgradePointsUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.additionalUpgradePointsRecipe);
        }
        if (!ConfigHandler.buttonUpgradeRecipeDisabled) {
            ItemRegistry.buttonUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.buttonUpgradeRecipe);
        }
        if (!ConfigHandler.damageBarUpgradeRecipeDisabled) {
            ItemRegistry.damageBarUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.damageBarUpgradeRecipe);
        }
        if (!ConfigHandler.depthUpgradeRecipeDisabled) {
            ItemRegistry.depthUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.depthUpgradeRecipe);
        }
        if (!ConfigHandler.eternityUpgradeRecipeDisabled) {
            ItemRegistry.eternityUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.eternityUpgradeRecipe);
        }
        if (ConfigHandler.renamingUpgradeRequired && !ConfigHandler.renamingUpgradeRecipeDisabled) {
            ItemRegistry.renamingUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.renamingUpgradeRecipe);
        }
        if (!ConfigHandler.nestingUpgradeRecipeDisabled) {
            ItemRegistry.nestingUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.nestingUpgradeRecipe);
        }
        if (!ConfigHandler.nestingUpgradeRecipeDisabled) {
            ItemRegistry.nestingAdvancedUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.nestingAdvancedUpgradeRecipe);
        }
        if (!ConfigHandler.quickDepositUpgradeRecipeDisabled) {
            ItemRegistry.quickDepositUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.quickDepositUpgradeRecipe);
        }
        if (!ConfigHandler.quickDepositPreciseUpgradeRecipeDisabled) {
            ItemRegistry.quickDepositPreciseUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.quickDepositPreciseUpgradeRecipe);
        }
        if (!ConfigHandler.craftingUpgradeRecipeDisabled) {
            ItemRegistry.craftingUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.craftingUpgradeRecipe);
        }
        if (!ConfigHandler.craftingSmallUpgradeRecipeDisabled) {
            ItemRegistry.craftingSmallUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.craftingSmallUpgradeRecipe);
        }
        if (!ConfigHandler.craftingTinyUpgradeRecipeDisabled) {
            ItemRegistry.craftingTinyUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.craftingTinyUpgradeRecipe);
        }
        if (!ConfigHandler.filterBasicUpgradeRecipeDisabled) {
            ItemRegistry.filterBasicUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.filterBasicUpgradeRecipe);
        }
        if (!ConfigHandler.filterFuzzyUpgradeRecipeDisabled) {
            ItemRegistry.filterFuzzyUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.filterFuzzyUpgradeRecipe);
        }
        if (!ConfigHandler.filterOreDictUpgradeRecipeDisabled) {
            ItemRegistry.filterOreDictUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.filterOreDictUpgradeRecipe);
        }
        if (!ConfigHandler.filterModSpecificUpgradeRecipeDisabled) {
            ItemRegistry.filterModSpecificUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.filterModSpecificUpgradeRecipe);
        }
        if (!ConfigHandler.filterAdvancedUpgradeRecipeDisabled) {
            ItemRegistry.filterAdvancedUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.filterAdvancedUpgradeRecipe);
        }
        if (!ConfigHandler.filterMiningUpgradeRecipeDisabled) {
            ItemRegistry.filterMiningUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.filterMiningUpgradeRecipe);
        }
        if (!ConfigHandler.filterVoidUpgradeRecipeDisabled) {
            ItemRegistry.filterVoidUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.filterVoidUpgradeRecipe);
        }
        if (!ConfigHandler.restockingUpgradeRecipeDisabled) {
            ItemRegistry.restockingUpgrade.setItemRecipe((IRecipe)ItemUpgradeRecipes.restockingUpgradeRecipe);
        }
    }

    private static void registerBackpackUpgradeRemovalRecipes() {
        for (int i = 0; i < ItemIBackpackRegistry.getSize(); ++i) {
            IBackpack backpack = ItemIBackpackRegistry.getBackpackAtIndex(i);
            if (!(backpack instanceof IUpgradableBackpack)) continue;
            BackpackRemoveUpgradeRecipe recipe = new BackpackRemoveUpgradeRecipe(new ItemStack((Item)((ItemBackpack)backpack)), new ItemStack((Item)((ItemBackpack)backpack)));
            GameRegistry.addRecipe((IRecipe)recipe);
            IAllRecipesRegistry.registerUpgradeRemovalRecipe(recipe);
        }
    }

    private static void registerBackpackUpgradeAdditionRecipes() {
        int i;
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        for (i = 0; i < ItemIUpgradeRegistry.getTotalSize(); ++i) {
            upgrades.add(new ItemStack((Item)ItemRegistry.upgradeItem, 1, i));
        }
        for (i = 0; i < ItemIBackpackRegistry.getSize(); ++i) {
            IBackpack backpack = ItemIBackpackRegistry.getBackpackAtIndex(i);
            if (!(backpack instanceof IUpgradableBackpack)) continue;
            for (ItemStack upgrade : upgrades) {
                int upgradeTier = ItemIUpgradeRegistry.getItemUpgrade(upgrade).getTier(upgrade);
                if (backpack instanceof ITieredBackpack) {
                    int backpackTier = ((ITieredBackpack)backpack).getTier(null);
                    if (upgradeTier > backpackTier) continue;
                    BackpackAddUpgradeRecipe recipe = new BackpackAddUpgradeRecipe(new ItemStack((Item)((ItemBackpack)backpack)), upgrade, new ItemStack((Item)((ItemBackpack)backpack)));
                    GameRegistry.addRecipe((IRecipe)recipe);
                    IAllRecipesRegistry.registerUpgradeAdditionRecipe(recipe);
                    continue;
                }
                BackpackAddUpgradeRecipe recipe = new BackpackAddUpgradeRecipe(new ItemStack((Item)((ItemBackpack)backpack)), upgrade, new ItemStack((Item)((ItemBackpack)backpack)));
                GameRegistry.addRecipe((IRecipe)recipe);
                IAllRecipesRegistry.registerUpgradeAdditionRecipe(recipe);
            }
        }
    }

    public static void registerBackpackTierRecipes() {
        for (int i = 0; i < ItemIBackpackRegistry.getSize(); ++i) {
            IBackpack backpack = ItemIBackpackRegistry.getBackpackAtIndex(i);
            if (!(backpack instanceof ITieredBackpack)) continue;
            ITieredBackpack newPack = (ITieredBackpack)backpack;
            List<Object[]> recipes = newPack.getTierRecipes(null);
            if (recipes == null) break;
            List<ITieredBackpack> upgradedPacks = newPack.getBackpacksAbove(null);
            if (recipes.isEmpty() || upgradedPacks == null || upgradedPacks.size() != recipes.size()) continue;
            for (int j = 0; j < recipes.size(); ++j) {
                BackpackIncreaseTierRecipe tierRecipe = new BackpackIncreaseTierRecipe(new ItemStack((Item)((ItemBackpack)upgradedPacks.get(j))), recipes.get(j));
                GameRegistry.addRecipe((IRecipe)tierRecipe);
                IAllRecipesRegistry.registerTierIncreaseRecipe(tierRecipe);
            }
        }
    }
}

