/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.network.server;

import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.network.NetworkingHandler;
import gr8pefish.ironbackpacks.network.client.ClientCurrentPackMessage;
import gr8pefish.ironbackpacks.util.NBTUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlayerSlotNumberMessage
implements IMessage {
    private int slotNumber;
    private int isSneaking;
    public static int SNEAKING = 0;
    public static int NOT_SNEAKING = 1;

    public PlayerSlotNumberMessage() {
    }

    public PlayerSlotNumberMessage(int slotNumber, int isSneaking) {
        this.slotNumber = slotNumber;
        this.isSneaking = isSneaking;
    }

    public void fromBytes(ByteBuf buf) {
        this.slotNumber = ByteBufUtils.readVarShort((ByteBuf)buf);
        this.isSneaking = ByteBufUtils.readVarShort((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.slotNumber);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.isSneaking);
    }

    public static class Handler
    implements IMessageHandler<PlayerSlotNumberMessage, IMessage> {
        public IMessage onMessage(PlayerSlotNumberMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack backpackStack = player.field_71071_by.func_70301_a(message.slotNumber);
            if (backpackStack != null) {
                NBTUtils.setUUID(backpackStack);
                PlayerWearingBackpackCapabilities.setCurrentBackpack((EntityLivingBase)player, backpackStack);
                NetworkingHandler.network.sendTo((IMessage)new ClientCurrentPackMessage(backpackStack), player);
                if (message.isSneaking == NOT_SNEAKING) {
                    backpackStack.func_77957_a(player.field_70170_p, (EntityPlayer)player, EnumHand.MAIN_HAND);
                } else {
                    ((ItemBackpack)backpackStack.func_77973_b()).handleBackpackOpening(backpackStack, player.field_70170_p, (EntityPlayer)player, EnumHand.MAIN_HAND, true);
                }
            }
            return null;
        }
    }
}

