/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.crafting;

import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IUpgradableBackpack;
import gr8pefish.ironbackpacks.api.items.upgrades.ItemIConflictingUpgrade;
import gr8pefish.ironbackpacks.api.recipes.IAddUpgradeRecipe;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.items.upgrades.ItemUpgrade;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.registry.ItemRegistry;
import gr8pefish.ironbackpacks.util.IronBackpacksConstants;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BackpackAddUpgradeRecipe
extends ShapelessOreRecipe
implements IAddUpgradeRecipe {
    private final ItemStack recipeOutput;

    public BackpackAddUpgradeRecipe(ItemStack recipeOutput, Object ... items) {
        super(recipeOutput, items);
        this.recipeOutput = recipeOutput;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        ItemStack backpack = BackpackAddUpgradeRecipe.getFirstUpgradableBackpack(inventoryCrafting);
        if (backpack == null) {
            return null;
        }
        ItemStack result = backpack.func_77946_l();
        ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(result);
        int totalUpgradePoints = IronBackpacksHelper.getTotalUpgradePointsFromNBT(result);
        ItemStack upgradeToApply = BackpackAddUpgradeRecipe.getFirstUpgrade(inventoryCrafting);
        NBTTagCompound nbtTagCompound = result.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            result.func_77982_d(nbtTagCompound);
        }
        boolean upgradeFound = false;
        NBTTagList tagList = new NBTTagList();
        if (totalUpgradePoints != 0 && upgradeToApply != null) {
            if (upgrades.size() == 0) {
                if (ItemUpgrade.areUpgradesEqual(upgradeToApply, ItemRegistry.additionalUpgradePointsUpgrade)) {
                    upgradeFound = this.applyAdditional(nbtTagCompound, result);
                } else if (IronBackpacksHelper.getUpgradePointsUsed(upgrades) + ItemUpgrade.getUpgradeCost(upgradeToApply) <= totalUpgradePoints) {
                    if (ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(upgradeToApply)) {
                        nbtTagCompound.func_74782_a("AddedAltGui", (NBTBase)upgradeToApply.func_77955_b(new NBTTagCompound()));
                    }
                    tagList.func_74742_a((NBTBase)upgradeToApply.func_77955_b(new NBTTagCompound()));
                    upgradeFound = true;
                }
            } else {
                if (ItemUpgrade.areUpgradesEqual(upgradeToApply, ItemRegistry.additionalUpgradePointsUpgrade)) {
                    upgradeFound = this.applyAdditional(nbtTagCompound, result);
                }
                for (ItemStack upgrade : upgrades) {
                    tagList.func_74742_a((NBTBase)upgrade.func_77955_b(new NBTTagCompound()));
                }
                if (!upgradeFound && !ItemUpgrade.areUpgradesEqual(upgradeToApply, ItemRegistry.additionalUpgradePointsUpgrade) && this.canApplyUpgrade(upgrades, totalUpgradePoints, upgradeToApply)) {
                    if (ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(upgradeToApply)) {
                        nbtTagCompound.func_74782_a("AddedAltGui", (NBTBase)upgradeToApply.func_77955_b(new NBTTagCompound()));
                    }
                    tagList.func_74742_a((NBTBase)upgradeToApply.func_77955_b(new NBTTagCompound()));
                    upgradeFound = true;
                }
            }
        } else if (upgradeToApply != null && ItemUpgrade.areUpgradesEqual(upgradeToApply, ItemRegistry.additionalUpgradePointsUpgrade)) {
            upgradeFound = this.applyAdditional(nbtTagCompound, result);
        }
        nbtTagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
        if (upgradeFound) {
            return result;
        }
        return null;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    private static ItemStack getFirstUpgradableBackpack(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.func_70463_b(j, i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof IUpgradableBackpack)) continue;
                return itemstack;
            }
        }
        return null;
    }

    private static ItemStack getFirstUpgrade(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.func_70463_b(j, i);
                if (itemstack == null || itemstack.func_77973_b() == null || !(itemstack.func_77973_b() instanceof ItemUpgrade) || !ItemIUpgradeRegistry.isInstanceOfAnyUpgrade(itemstack)) continue;
                ItemStack returnStack = itemstack.func_77946_l();
                returnStack.field_77994_a = 1;
                return returnStack;
            }
        }
        return null;
    }

    private boolean canApplyUpgrade(ArrayList<ItemStack> upgrades, int totalUpgradePoints, ItemStack upgradeToApply) {
        if (ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(upgradeToApply) || ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(upgradeToApply)) {
            for (ItemStack upgrade : upgrades) {
                if (!UpgradeMethods.areUpgradesFunctionallyEquivalent(upgrade, upgradeToApply)) continue;
                return false;
            }
            if (ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(upgradeToApply)) {
                if (this.hasConflictingUpgradeInUpgrades(upgradeToApply, upgrades)) {
                    return false;
                }
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + ItemUpgrade.getUpgradeCost(upgradeToApply) <= totalUpgradePoints;
            }
            if (UpgradeMethods.getAltGuiUpgradesApplied(upgrades) + 1 <= IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED) {
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + ItemUpgrade.getUpgradeCost(upgradeToApply) <= totalUpgradePoints;
            }
            return false;
        }
        for (ItemStack upgrade : upgrades) {
            if (!UpgradeMethods.areUpgradesFunctionallyEquivalent(upgrade, upgradeToApply)) continue;
            return false;
        }
        return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + ItemUpgrade.getUpgradeCost(upgradeToApply) <= totalUpgradePoints;
    }

    private boolean hasConflictingUpgradeInUpgrades(ItemStack upgradeToApply, ArrayList<ItemStack> upgrades) {
        List<ItemIConflictingUpgrade> conflictingUpgrades = ItemIUpgradeRegistry.getItemIConflictingUpgrade(upgradeToApply).getConflictingUpgrades(upgradeToApply);
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(stack) || !conflictingUpgrades.contains(ItemIUpgradeRegistry.getItemIConflictingUpgrade(stack))) continue;
            return true;
        }
        return false;
    }

    private boolean applyAdditional(NBTTagCompound nbtTagCompound, ItemStack backpack) {
        ItemBackpack backpackBase = (ItemBackpack)backpack.func_77973_b();
        if (backpackBase == null) {
            return false;
        }
        if (nbtTagCompound.func_74764_b("AdditionalPoints")) {
            int[] oldValuesArray = nbtTagCompound.func_74759_k("AdditionalPoints");
            if (oldValuesArray[1] < ((IUpgradableBackpack)backpack.func_77973_b()).getAdditionalUpgradePoints(backpack)) {
                oldValuesArray[1] = oldValuesArray[1] + 1;
                nbtTagCompound.func_74782_a("AdditionalPoints", (NBTBase)new NBTTagIntArray(new int[]{ConfigHandler.additionalUpgradePointsIncrease + oldValuesArray[0], oldValuesArray[1]}));
                return true;
            }
        } else if (((IUpgradableBackpack)backpack.func_77973_b()).getAdditionalUpgradePoints(backpack) > 0) {
            nbtTagCompound.func_74782_a("AdditionalPoints", (NBTBase)new NBTTagIntArray(new int[]{ConfigHandler.additionalUpgradePointsIncrease, 1}));
            return true;
        }
        return false;
    }
}

