/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.commands;

import gr8pefish.ironbackpacks.capabilities.player.PlayerDeathBackpackCapabilities;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.network.NetworkingHandler;
import gr8pefish.ironbackpacks.network.client.ClientCurrentPackMessage;
import gr8pefish.ironbackpacks.network.client.ClientEquippedPackMessage;
import gr8pefish.ironbackpacks.util.Logger;
import gr8pefish.ironbackpacks.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class IronBackpacksCommands
extends CommandBase {
    private final String FORCE_REMOVE_EQUIPPED = "forceRemoveEquippedBackpack";

    @Nonnull
    public String func_71517_b() {
        return "ib";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "/ib forceRemoveEquippedBackpack [player]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params) throws CommandException {
        if (params.length > 0 && params.length <= 2) {
            if (params[0].equalsIgnoreCase("forceRemoveEquippedBackpack")) {
                if (params.length == 2) {
                    try {
                        EntityPlayerMP playerMP = IronBackpacksCommands.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)params[1]);
                        ItemStack stack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)playerMP);
                        if (stack.field_77994_a == 0) {
                            ItemStack newStack = stack.func_77946_l();
                            ++newStack.field_77994_a;
                            PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)playerMP, newStack);
                            stack = newStack;
                        }
                        playerMP.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
                        PlayerWearingBackpackCapabilities.reset((EntityLivingBase)playerMP);
                        PlayerDeathBackpackCapabilities.reset((EntityLivingBase)playerMP);
                        NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(null), playerMP);
                        NetworkingHandler.network.sendTo((IMessage)new ClientCurrentPackMessage(null), playerMP);
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextUtils.localizeEffect("chat.ironbackpacks.command.removedEquippedPack", new Object[0]) + " " + playerMP.func_70005_c_() + "."));
                    }
                    catch (Exception e) {
                        Logger.warn("Couldn't process Iron Backpacks command to delete the user's backpack!");
                    }
                } else {
                    try {
                        EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                        ItemStack stack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
                        if (stack.field_77994_a == 0) {
                            ItemStack newStack = stack.func_77946_l();
                            ++newStack.field_77994_a;
                            PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)player, newStack);
                            stack = newStack;
                        }
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
                        PlayerWearingBackpackCapabilities.reset((EntityLivingBase)player);
                        PlayerDeathBackpackCapabilities.reset((EntityLivingBase)player);
                        NetworkingHandler.network.sendTo((IMessage)new ClientEquippedPackMessage(null), (EntityPlayerMP)sender.func_174793_f());
                        NetworkingHandler.network.sendTo((IMessage)new ClientCurrentPackMessage(null), (EntityPlayerMP)sender.func_174793_f());
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextUtils.localizeEffect("chat.ironbackpacks.command.removedYourEquippedPack", new Object[0])));
                    }
                    catch (Exception e) {
                        Logger.warn("Couldn't process Iron Backpacks command to remove this user's backpack!");
                    }
                }
            }
        } else {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        ArrayList<String> tabCompletion = new ArrayList<String>();
        if (args.length <= 1) {
            tabCompletion.addAll(IronBackpacksCommands.func_71530_a((String[])args, (String[])new String[]{"forceRemoveEquippedBackpack"}));
        } else {
            tabCompletion.addAll(IronBackpacksCommands.func_71530_a((String[])args, (String[])server.func_71213_z()));
        }
        return tabCompletion;
    }
}

