/*
 * Decompiled with CFR 0.152.
 */
package ts2k16.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import ts2k16.core.TS2K16;
import ts2k16.core.TSSettings;

public class ConfigHandler {
    public static Configuration config;

    public static void initConfigs() {
        if (config == null) {
            TS2K16.logger.log(Level.ERROR, "Config attempted to be loaded before it was initialised!");
            return;
        }
        config.load();
        TSSettings.allowSprint = config.getBoolean("Allow Sprinting", "general", true, "Allows users to sprint instead of sneaking");
        TSSettings.cooldown = config.getInt("Cooldown", "general", 10, 0, Integer.MAX_VALUE, "Minimum number of ticks between each growth");
        TSSettings.radius = config.getInt("Radius", "general", 3, 1, 16, "Growth effect radius around the player");
        TSSettings.chance = config.getInt("Chance", "general", 25, 1, 100, "Percent chance that growth will occur");
        TSSettings.allPlants = config.getBoolean("All Plants", "general", false, "Make growth effect all plants, not just saplings");
        String[] wl = config.getStringList("Whitelist", "general", new String[0], "Additional plants that can be affected (Case Sensitive)");
        String[] bl = config.getStringList("Blacklist", "general", new String[]{"minecraft:grass"}, "Plants blacklisted from the effect (Case Sensitive)");
        TSSettings.whitelist = new ArrayList<String>(Arrays.asList(wl));
        TSSettings.blacklist = new ArrayList<String>(Arrays.asList(bl));
        config.save();
    }
}

