/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.UndisableableConfigException;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;

public abstract class ConfigurableTypeAction<C extends ExtendedConfig<C>> {
    public void commonRun(ExtendedConfig<C> eConfig, Configuration config) {
        if (eConfig.isDisableable()) {
            this.preRun(eConfig.downCast(), config, true);
        }
        if (eConfig.isEnabled()) {
            this.postRun(eConfig.downCast(), config);
        } else {
            if (!eConfig.isDisableable()) {
                throw new UndisableableConfigException(eConfig);
            }
            this.onSkipRegistration(eConfig);
        }
    }

    protected void onSkipRegistration(ExtendedConfig<C> eConfig) {
        eConfig.getMod().log(Level.TRACE, "Skipped registering " + eConfig.getNamedId());
    }

    public abstract void preRun(C var1, Configuration var2, boolean var3);

    public abstract void postRun(C var1, Configuration var2);

    public void polish(C config) {
    }

    public static <T extends IForgeRegistryEntry> void register(T instance, ExtendedConfig config) {
        instance.setRegistryName(new ResourceLocation(config.getMod().getModId(), config.getNamedId()));
        GameRegistry.register(instance);
    }
}

