/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.key;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.cyclops.cyclopscore.client.key.IKeyHandler;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public class KeyRegistry
implements IKeyRegistry {
    private final Multimap<KeyBinding, IKeyHandler> keyHandlerMap = HashMultimap.create();

    public static KeyBinding newKeyBinding(ModBase mod, String name, int defaultKey) {
        String id = L10NHelpers.localize("key." + mod.getModId() + "." + name);
        String category = L10NHelpers.localize("key.categories." + mod.getModId());
        return new KeyBinding(id, defaultKey, category);
    }

    @Override
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerKeyInput(InputEvent.KeyInputEvent event) {
        for (KeyBinding kb : this.keyHandlerMap.keySet()) {
            if (!kb.func_151468_f()) continue;
            this.fireKeyPressed(kb);
        }
    }

    private void fireKeyPressed(KeyBinding kb) {
        for (IKeyHandler h : this.keyHandlerMap.get((Object)kb)) {
            h.onKeyPressed(kb);
        }
    }

    @Override
    public void addKeyHandler(KeyBinding kb, IKeyHandler handler) {
        this.keyHandlerMap.put((Object)kb, (Object)handler);
    }
}

