/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.tiles;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;
import net.xalcon.energyconverters.EnergyConverters;
import net.xalcon.energyconverters.common.tiles.TileEntityEnergyBridge;
import net.xalcon.energyconverters.common.tiles.TileEntityEnergyConvertersProducer;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyInterfaceTile;

@Optional.Interface(iface="reborncore.api.power.IEnergyInterfaceTile", modid="reborncore", striprefs=true)
public class TileEntityTechRebornProducer
extends TileEntityEnergyConvertersProducer
implements ITickable,
IEnergyInterfaceTile,
IListInfoProvider {
    private EnumPowerTier tier;

    public TileEntityTechRebornProducer() {
    }

    public TileEntityTechRebornProducer(EnumPowerTier tier) {
        this.tier = tier;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tier = EnumPowerTier.values()[compound.func_74762_e("tier")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tier", this.tier.ordinal());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.getEnergy() > 0.0) {
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity tile;
                if (!this.canProvideEnergy(side) || !((tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side))) instanceof IEnergyInterfaceTile)) continue;
                IEnergyInterfaceTile eFace = (IEnergyInterfaceTile)tile;
                if (eFace.getTier().ordinal() < this.getTier().ordinal()) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)this.field_174879_c.func_177958_n() + this.func_145831_w().field_73012_v.nextDouble() + (double)(side.func_82601_c() / 2);
                        double d8 = (double)this.field_174879_c.func_177956_o() + this.func_145831_w().field_73012_v.nextDouble() + 1.0;
                        double d13 = (double)this.field_174879_c.func_177952_p() + this.func_145831_w().field_73012_v.nextDouble() + (double)(side.func_82599_e() / 2);
                        this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_LARGE, d3, d8, d13, 0.0, 0.0, 0.0, new int[0]);
                    }
                    continue;
                }
                if (!eFace.canAcceptEnergy(side.func_176734_d()) || !eFace.canAddEnergy(Math.min(this.getEnergy(), this.getMaxOutput()))) continue;
                eFace.addEnergy(this.useEnergy(Math.min(this.getEnergy(), this.getMaxOutput())));
            }
        }
    }

    public double getEnergy() {
        TileEntityEnergyBridge bridge = this.getEnergyBridge();
        return bridge == null ? 0.0 : bridge.getStoredEnergy();
    }

    public void setEnergy(double v) {
    }

    public double getMaxPower() {
        TileEntityEnergyBridge bridge = this.getEnergyBridge();
        return bridge == null ? 0.0 : bridge.getStoredEnergyMax();
    }

    public boolean canAddEnergy(double v) {
        return false;
    }

    public double addEnergy(double v) {
        return 0.0;
    }

    public double addEnergy(double v, boolean b) {
        return 0.0;
    }

    public boolean canUseEnergy(double v) {
        return true;
    }

    public double useEnergy(double v) {
        return this.useEnergy(v, false);
    }

    public double useEnergy(double v, boolean b) {
        double ratio = EnergyConverters.getConfig().getRfConversion();
        TileEntityEnergyBridge bridge = this.getEnergyBridge();
        return bridge == null ? 0.0 : bridge.getEnergy(v * ratio, b) / ratio;
    }

    public boolean canAcceptEnergy(EnumFacing enumFacing) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing enumFacing) {
        return true;
    }

    public double getMaxOutput() {
        return this.tier.getMaxOutput();
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return this.tier;
    }

    public void addInfo(List<String> list, boolean b) {
    }
}

