/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.xalcon.energyconverters.EnergyConverters;
import net.xalcon.energyconverters.common.blocks.BlockBase;
import reborncore.api.power.EnumPowerTier;

public abstract class BlockConverterTechRebornBase
extends BlockBase {
    public static final PropertyEnum<PowerTierMap> TYPE = PropertyEnum.func_177709_a((String)"tier", PowerTierMap.class);

    public BlockConverterTechRebornBase(Material material, String name) {
        super(material, name);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (PowerTierMap t : PowerTierMap.values()) {
            list.add(new ItemStack(itemIn, 1, t.getMeta()));
        }
    }

    @Override
    public void registerItemModel(ItemBlock itemBlock) {
        for (PowerTierMap t : PowerTierMap.values()) {
            EnergyConverters.Proxy.registerItemRenderer((Item)itemBlock, t.ordinal(), this.internalName, "tier=" + t.func_176610_l());
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)PowerTierMap.values()[meta]));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public int func_176201_c(IBlockState state) {
        return ((PowerTierMap)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum PowerTierMap implements IStringSerializable
    {
        LOW(EnumPowerTier.LOW, "low", 0),
        MEDIUM(EnumPowerTier.MEDIUM, "medium", 1),
        HIGH(EnumPowerTier.HIGH, "high", 2),
        EXTREME(EnumPowerTier.EXTREME, "extreme", 3),
        INSANE(EnumPowerTier.INSANE, "insane", 4),
        INFINITE(EnumPowerTier.INFINITE, "infinite", 5);

        private EnumPowerTier tier;
        private String name;
        private int meta;

        private PowerTierMap(EnumPowerTier tier, String name, int meta) {
            this.tier = tier;
            this.name = name;
            this.meta = meta;
        }

        public EnumPowerTier getTier() {
            return this.tier;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

