/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world;

import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamSettingsEvent;
import com.feed_the_beast.ftbl.lib.EnumTeamPrivacyLevel;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.config.PropertyEnum;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUTeamData
implements INBTSerializable<NBTBase> {
    public final PropertyEnum<EnumTeamPrivacyLevel> blocks = new PropertyEnum(EnumTeamPrivacyLevel.NAME_MAP, (Enum)EnumTeamPrivacyLevel.ALLIES);
    public final PropertyBool explosions = new PropertyBool(false);
    public final PropertyBool fakePlayers = new PropertyBool(true);

    @Nullable
    public static FTBUTeamData get(IForgeTeam t) {
        return (FTBUTeamData)t.getData(FTBLibIntegration.FTBU_DATA);
    }

    public NBTBase serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("Explosions", this.explosions.getBoolean());
        nbt.func_74757_a("FakePlayers", this.fakePlayers.getBoolean());
        return nbt;
    }

    public void deserializeNBT(NBTBase nbt0) {
        if (nbt0 instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbt0;
            this.explosions.setBoolean(nbt.func_74767_n("Explosions"));
            this.fakePlayers.setBoolean(nbt.func_74767_n("FakePlayers"));
        } else {
            int flags = ((NBTPrimitive)nbt0).func_150287_d();
            this.explosions.setBoolean(!Bits.getFlag((int)flags, (int)1));
            this.fakePlayers.setBoolean(Bits.getFlag((int)flags, (int)2));
        }
    }

    public void addConfig(ForgeTeamSettingsEvent event) {
        String group = "ftbu";
        event.add(group, "explosions", (IConfigValue)this.explosions);
        event.add(group, "fake_players", (IConfigValue)this.fakePlayers);
        event.add(group, "blocks", this.blocks);
    }
}

