/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.integration;

import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import com.feed_the_beast.ftbu.client.FTBUClient;
import com.feed_the_beast.ftbu.client.FTBUClientConfig;
import com.feed_the_beast.ftbu.gui.ClaimedChunks;
import com.feed_the_beast.ftbu.integration.IJMIntegration;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksRequest;
import com.feed_the_beast.ftbu.net.MessageJMRequest;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@ClientPlugin
public class JourneyMapIntegration
implements IClientPlugin,
IJMIntegration {
    private static Minecraft mc;
    private IClientAPI clientAPI;
    private static final Map<ChunkPos, PolygonOverlay> POLYGONS;
    private static ChunkPos lastPosition;

    public void initialize(IClientAPI api) {
        mc = Minecraft.func_71410_x();
        this.clientAPI = api;
        FTBUClient.JM_INTEGRATION = this;
        MinecraftForge.EVENT_BUS.register(JourneyMapIntegration.class);
        api.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.DISPLAY_UPDATE, ClientEvent.Type.MAPPING_STARTED, ClientEvent.Type.MAPPING_STOPPED));
    }

    public String getModId() {
        return "ftbu";
    }

    public void onEvent(ClientEvent event) {
        switch (event.type) {
            case DISPLAY_UPDATE: {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g == null) break;
                new MessageClaimedChunksRequest((Entity)mc.field_71439_g).sendToServer();
                break;
            }
            case MAPPING_STOPPED: {
                this.clearData();
            }
        }
    }

    @Override
    public void clearData() {
        if (!POLYGONS.isEmpty()) {
            POLYGONS.clear();
            this.clientAPI.removeAll("ftbu");
        }
    }

    @Override
    public void chunkChanged(ChunkPos pos, ClaimedChunks.Data chunk) {
        if (!(POLYGONS.isEmpty() || FTBUClientConfig.JOURNEYMAP_OVERLAY.getBoolean() && this.clientAPI.playerAccepts("ftbu", DisplayType.Polygon))) {
            this.clearData();
            return;
        }
        try {
            PolygonOverlay p = POLYGONS.get(pos);
            if (p != null) {
                this.clientAPI.remove((Displayable)p);
                if (!chunk.hasUpgrade(ChunkUpgrade.CLAIMED)) {
                    POLYGONS.remove(pos);
                }
            }
            if (chunk.hasUpgrade(ChunkUpgrade.CLAIMED)) {
                int dim = 0;
                MapPolygon poly = PolygonHelper.createChunkPolygon((int)pos.field_77276_a, (int)100, (int)pos.field_77275_b);
                ShapeProperties shapeProperties = new ShapeProperties();
                shapeProperties.setFillOpacity(0.2f);
                shapeProperties.setStrokeOpacity(0.1f);
                shapeProperties.setFillColor(chunk.team.color.getColor().rgba());
                shapeProperties.setStrokeColor(shapeProperties.getFillColor());
                p = new PolygonOverlay("ftbu", "claimed_" + dim + '_' + pos.field_77276_a + '_' + pos.field_77275_b, dim, shapeProperties, poly);
                p.setOverlayGroupName("Claimed Chunks").setTitle(chunk.team.formattedName + "\n" + TextFormatting.GREEN + ChunkUpgrade.CLAIMED.getLangKey().translate());
                POLYGONS.put(pos, p);
                this.clientAPI.show((Displayable)p);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onEnteringChunk(EntityEvent.EnteringChunk event) {
        if (FTBUClientConfig.JOURNEYMAP_OVERLAY.getBoolean() && event.getEntity() == JourneyMapIntegration.mc.field_71439_g && (lastPosition == null || MathUtils.dist((double)event.getNewChunkX(), (double)event.getNewChunkZ(), (double)JourneyMapIntegration.lastPosition.field_77276_a, (double)JourneyMapIntegration.lastPosition.field_77275_b) >= 3.0)) {
            lastPosition = new ChunkPos(event.getNewChunkX(), event.getNewChunkZ());
            new MessageJMRequest((Entity)JourneyMapIntegration.mc.field_71439_g).sendToServer();
        }
    }

    static {
        POLYGONS = new HashMap<ChunkPos, PolygonOverlay>();
        lastPosition = null;
    }
}

