/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles;

import com.girafi.waddles.entity.EntityAdeliePenguin;
import com.girafi.waddles.proxy.CommonProxy;
import com.girafi.waddles.utils.ConfigurationHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="waddles", name="Waddles", version="0.5.4", dependencies="required-after:Forge@[12.18.1.2011,)", guiFactory="com.girafi.waddles.client.gui.GuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class Waddles {
    @Mod.Instance(value="waddles")
    public static Waddles instance;
    @SidedProxy(clientSide="com.girafi.waddles.proxy.ClientProxy", serverSide="com.girafi.waddles.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final ResourceLocation LOOT_ENTITIES_PENGUIN_FISH;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.init(new File(event.getModConfigurationDirectory(), "Waddles.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
        proxy.registerRenders();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EntityRegistry.registerModEntity(EntityAdeliePenguin.class, (String)"penguin", (int)0, (Object)instance, (int)64, (int)1, (boolean)true, (int)0, (int)0xFFFFFF);
        ArrayList spawnable_biomes = Lists.newArrayList();
        for (Biome biome : Biome.field_185377_q) {
            HashSet types = Sets.newHashSet((Object[])BiomeDictionary.getTypesForBiome((Biome)biome));
            if (!types.contains(BiomeDictionary.Type.SNOWY) || types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.NETHER) || biome.func_76747_a(EnumCreatureType.CREATURE).isEmpty()) continue;
            System.out.println("Spawn Penguin");
            spawnable_biomes.add(biome);
        }
        this.addPenguinSpawn(EntityAdeliePenguin.class, 2, 1, 4, spawnable_biomes.toArray(new Biome[spawnable_biomes.size()]));
    }

    private void addPenguinSpawn(Class<? extends EntityAgeable> penguinClass, int defaultWeight, int defaultMin, int defaultMax, Biome ... biomes) {
        String subCategoryNames = "spawn chances.adelie_penguin";
        int weight = ConfigurationHandler.config.get(subCategoryNames, "Weight", defaultWeight).getInt();
        int min = ConfigurationHandler.config.get(subCategoryNames, "Min", defaultMin).getInt();
        int max = ConfigurationHandler.config.get(subCategoryNames, "Max", defaultMax).getInt();
        ConfigurationHandler.config.save();
        if (weight != 0) {
            EntityRegistry.addSpawn(penguinClass, (int)weight, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
        }
    }

    static {
        LOOT_ENTITIES_PENGUIN_FISH = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("waddles", "entities/penguin"));
    }
}

