/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.Lists;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ServerHandler;
import cpw.mods.inventorysorter.SideProxy;
import java.util.List;
import java.util.Properties;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="inventorysorter", name="Inventory Sorter", guiFactory="cpw.mods.inventorysorter.GuiConfigFactory", acceptedMinecraftVersions="[1.9.4,1.11)")
public class InventorySorter {
    @Mod.Instance(value="inventorysorter")
    public static InventorySorter INSTANCE;
    public Logger log;
    public SimpleNetworkWrapper channel;
    final List slotblacklist = Lists.newArrayList();

    @Mod.EventHandler
    public void handleimc(FMLInterModComms.IMCEvent evt) {
        for (FMLInterModComms.IMCMessage msg : evt.getMessages()) {
            if (!"slotblacklist".equals(msg.key) || !msg.isStringMessage()) continue;
            this.slotblacklist.add(msg.getStringValue());
        }
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent evt) {
        Properties versionProperties = evt.getVersionProperties();
        evt.getModMetadata().version = versionProperties != null ? versionProperties.getProperty("inventorysorter.version") : "1.0";
        SideProxy.INSTANCE.loadConfiguration(evt.getSuggestedConfigurationFile());
        this.log = evt.getModLog();
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel("inventorysorter");
        this.channel.registerMessage(ServerHandler.class, Network.ActionMessage.class, 1, Side.SERVER);
        SideProxy.INSTANCE.bindKeys();
        FMLInterModComms.sendMessage((String)"inventorysorter", (String)"slotblacklist", (String)"codechicken.core.inventory.SlotDummy");
    }
}

