/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import pl.asie.charset.lib.recipe.IRecipeObject;
import pl.asie.charset.lib.recipe.JEIPluginCharsetLib;
import pl.asie.charset.lib.recipe.RecipeCharset;

public class JEIRecipeCharset
extends BlankRecipeWrapper
implements ICraftingRecipeWrapper {
    protected final RecipeCharset recipe;

    public static JEIRecipeCharset create(RecipeCharset recipe) {
        return recipe.shapeless ? new Shapeless(recipe) : new Shaped(recipe);
    }

    private JEIRecipeCharset(RecipeCharset recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        Object output = this.recipe.output.preview();
        for (IRecipeObject o : this.recipe.input) {
            inputs.add(o != null ? o.preview() : null);
        }
        ingredients.setInputLists(ItemStack.class, JEIPluginCharsetLib.STACKS.expandRecipeItemStackInputs(inputs));
        if (output instanceof ItemStack) {
            ingredients.setOutputs(ItemStack.class, JEIPluginCharsetLib.STACKS.getSubtypes((ItemStack)output));
        } else if (output instanceof List) {
            ingredients.setOutputs(ItemStack.class, (List)output);
        }
    }

    public static class Shaped
    extends JEIRecipeCharset
    implements IShapedCraftingRecipeWrapper {
        public Shaped(RecipeCharset recipe) {
            super(recipe);
        }

        public int getWidth() {
            return this.recipe.width;
        }

        public int getHeight() {
            return this.recipe.height;
        }
    }

    public static class Shapeless
    extends JEIRecipeCharset {
        public Shapeless(RecipeCharset recipe) {
            super(recipe);
        }
    }

    public static class Handler
    implements IRecipeHandler<RecipeCharset> {
        @Nonnull
        public Class<RecipeCharset> getRecipeClass() {
            return RecipeCharset.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "minecraft.crafting";
        }

        @Nonnull
        public String getRecipeCategoryUid(@Nonnull RecipeCharset recipe) {
            return "minecraft.crafting";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull RecipeCharset recipe) {
            return JEIRecipeCharset.create(recipe);
        }

        public boolean isRecipeValid(@Nonnull RecipeCharset recipe) {
            return true;
        }
    }
}

