/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import net.minecraft.network.INetHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.network.Packet;

public abstract class PacketPart
extends Packet {
    protected IMultipart part;

    public PacketPart() {
    }

    public PacketPart(IMultipart part) {
        this.part = part;
    }

    @Override
    public void readData(INetHandler handler, ByteBuf buf) {
        IMultipartContainer container;
        int dim = buf.readInt();
        int x = buf.readInt();
        int y = buf.readUnsignedShort();
        int z = buf.readInt();
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        UUID id = new UUID(l1, l2);
        World w = ModCharsetLib.proxy.getLocalWorld(dim);
        if (w != null && (container = MultipartHelper.getPartContainer((IBlockAccess)w, (BlockPos)new BlockPos(x, y, z))) != null) {
            this.part = container.getPartFromID(id);
        }
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeInt(this.part.getWorld().field_73011_w.getDimension());
        buf.writeInt(this.part.getPos().func_177958_n());
        buf.writeShort(this.part.getPos().func_177956_o());
        buf.writeInt(this.part.getPos().func_177952_p());
        UUID id = this.part.getContainer().getPartID(this.part);
        if (id == null) {
            ModCharsetLib.logger.warn("Part ID was null @ " + this.part.getPos().toString() + "! Please report to mod author!", new Throwable());
            new Throwable().printStackTrace();
            id = UUID.randomUUID();
        }
        buf.writeLong(id.getMostSignificantBits());
        buf.writeLong(id.getLeastSignificantBits());
    }
}

