/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.blocks.multipart;

import com.mrdimka.hammercore.api.INoItemBlock;
import com.mrdimka.hammercore.api.mhb.BlockTraceable;
import com.mrdimka.hammercore.api.mhb.ICubeManager;
import com.mrdimka.hammercore.api.multipart.ItemBlockMultipartProvider;
import com.mrdimka.hammercore.api.multipart.MultipartSignature;
import com.mrdimka.hammercore.common.blocks.multipart.TileMultipart;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import com.mrdimka.hammercore.vec.Cuboid6;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMultipart
extends BlockTraceable
implements ITileEntityProvider,
ICubeManager,
INoItemBlock {
    private static final Cuboid6[] EMPTY_CUBOID_ARRAY = new Cuboid6[0];

    public BlockMultipart() {
        super(Material.field_151573_f);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_149663_c("multipart");
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        MultipartSignature signature;
        TileMultipart tmp = WorldUtil.cast(world.func_175625_s(pos), TileMultipart.class);
        Cuboid6 cbd = this.getCuboidFromPlayer(player, pos);
        if (tmp != null && cbd != null && (signature = tmp.getSignature(cbd.center().toVec3d())) != null) {
            return signature.getPickBlock(player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public AxisAlignedBB getFullBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return field_185505_j;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityPlayer) {
            MultipartSignature s;
            EntityPlayer player = (EntityPlayer)entity;
            Cuboid6 cbd = this.getCuboidFromPlayer(player, pos);
            TileMultipart tmp = WorldUtil.cast(world.func_175625_s(pos), TileMultipart.class);
            if (tmp != null && cbd != null && (s = tmp.getSignature(cbd.center().toVec3d())).getState() != null) {
                return s.getSoundType(player);
            }
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public boolean func_149662_c(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    public boolean func_149721_r(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    public boolean func_185481_k(IBlockState p_isFullyOpaque_1_) {
        return false;
    }

    public boolean func_149686_d(IBlockState p_isFullCube_1_) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileMultipart();
    }

    @Override
    public Cuboid6[] getCuboids(World world, BlockPos pos, IBlockState state) {
        TileMultipart tmp = WorldUtil.cast(world.func_175625_s(pos), TileMultipart.class);
        return tmp != null ? tmp.getCuboids() : EMPTY_CUBOID_ARRAY;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipart tmp = WorldUtil.cast(world.func_175625_s(pos), TileMultipart.class);
        return tmp != null ? tmp.getLightLevel() : 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean onBoxActivated(int boxID, Cuboid6 box, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult r;
        ItemStack stack;
        boolean activated;
        Cuboid6 cbd = this.getCuboidFromPlayer(playerIn, pos);
        TileMultipart tmp = WorldUtil.cast(worldIn.func_175625_s(pos), TileMultipart.class);
        boolean bl = activated = tmp != null ? tmp.onBoxActivated(boxID, cbd, worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ) : false;
        if (!activated && (stack = playerIn.func_184586_b(hand)) != null && stack.func_77973_b() instanceof ItemBlockMultipartProvider && (r = stack.func_77973_b().func_180614_a(stack, playerIn, worldIn, pos, hand, facing, hitX + 1.0f, hitY, hitZ)) == EnumActionResult.SUCCESS) {
            playerIn.func_184609_a(hand);
        }
        return activated;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        Cuboid6 cbd = this.getCuboidFromPlayer(player, pos);
        TileMultipart tmp = WorldUtil.cast(worldIn.func_175625_s(pos), TileMultipart.class);
        if (tmp != null && cbd != null) {
            MultipartSignature signature = tmp.getSignature(cbd.center().toVec3d());
            return signature.getHardness(player);
        }
        return 0.0f;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileMultipart tmp = WorldUtil.cast(blockAccess.func_175625_s(pos), TileMultipart.class);
        return tmp != null ? tmp.getWeakPower(side) : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileMultipart tmp = WorldUtil.cast(blockAccess.func_175625_s(pos), TileMultipart.class);
        return tmp != null ? tmp.getStrongPower(side) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        MultipartSignature signature;
        TileMultipart tmp = WorldUtil.cast(world.func_175625_s(target.func_178782_a()), TileMultipart.class);
        Cuboid6 cbd = this.getCuboidFromRTR(world, target);
        if (tmp != null && cbd != null && (signature = tmp.getSignature(cbd.aabb().func_189972_c())) != null) {
            signature.addHitEffects(world, target, manager);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TileMultipart tmp = WorldUtil.cast(world.func_175625_s(pos), TileMultipart.class);
        if (tmp != null) {
            for (MultipartSignature s : tmp.signatures()) {
                s.addDestroyEffects(world, pos, manager);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMultipart tmp = WorldUtil.cast(world.func_175625_s(pos), TileMultipart.class);
        for (MultipartSignature s : tmp.signatures()) {
            if (s == null || !s.canConnectRedstone(side)) continue;
            return true;
        }
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        TileMultipart tmp = WorldUtil.cast(worldIn.func_175625_s(pos), TileMultipart.class);
        if (tmp != null) {
            for (MultipartSignature s : tmp.signatures()) {
                tmp.removeMultipart(s, true);
            }
        }
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileMultipart tmp = WorldUtil.cast(worldIn.func_175625_s(pos), TileMultipart.class);
        if (tmp != null) {
            tmp.randomDisplayTick(rand);
        }
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileMultipart tmp = WorldUtil.cast(world.func_175625_s(pos), TileMultipart.class);
        if (tmp != null) {
            for (MultipartSignature sign : tmp.signatures()) {
                sign.onNeighborChange(world, pos, neighbor);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tryBreakBlock(BlockEvent.BreakEvent evt) {
        MultipartSignature signature;
        Cuboid6 cbd;
        TileMultipart tmp;
        if (evt.getState().func_177230_c() == this && (tmp = WorldUtil.cast(evt.getWorld().func_175625_s(evt.getPos()), TileMultipart.class)) != null && !evt.getWorld().field_72995_K && (cbd = this.getCuboidFromPlayer(evt.getPlayer(), evt.getPos())) != null && (signature = tmp.getSignature(cbd.center().toVec3d())) != null) {
            tmp.removeMultipart(signature, !evt.getPlayer().field_71075_bZ.field_75098_d);
            evt.setCanceled(true);
        }
    }
}

