/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world;

import codechicken.lib.world.WorldExtension;
import codechicken.lib.world.WorldExtensionInstantiator;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldExtensionManager {
    private static boolean initialised;
    private static ArrayList<WorldExtensionInstantiator> extensionIntialisers;
    private static HashMap<World, WorldExtension[]> worldMap;

    public static void registerWorldExtension(WorldExtensionInstantiator init) {
        if (!initialised) {
            WorldExtensionManager.init();
        }
        init.instantiatorID = extensionIntialisers.size();
        extensionIntialisers.add(init);
    }

    private static void init() {
        initialised = true;
        MinecraftForge.EVENT_BUS.register((Object)new WorldExtensionEventHandler());
    }

    private static void onWorldLoad(World world) {
        WorldExtension[] extensions = new WorldExtension[extensionIntialisers.size()];
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = extensionIntialisers.get(i).createWorldExtension(world);
        }
        worldMap.put(world, extensions);
        for (WorldExtension extension : extensions) {
            extension.load();
        }
    }

    private static void createChunkExtension(World world, Chunk chunk) {
        WorldExtension[] extensions = worldMap.get(world);
        for (int i = 0; i < extensionIntialisers.size(); ++i) {
            if (extensions[i].containsChunk(chunk)) continue;
            extensions[i].addChunk(extensionIntialisers.get(i).createChunkExtension(chunk, extensions[i]));
        }
    }

    private static void removeChunk(World world, Chunk chunk) {
        for (WorldExtension extension : worldMap.get(world)) {
            extension.remChunk(chunk);
        }
    }

    private static void preTick(World world) {
        for (WorldExtension extension : worldMap.get(world)) {
            extension.preTick();
        }
    }

    private static void postTick(World world) {
        for (WorldExtension extension : worldMap.get(world)) {
            extension.postTick();
        }
    }

    public static WorldExtension getWorldExtension(World world, int instantiatorID) {
        return worldMap.get(world)[instantiatorID];
    }

    static {
        extensionIntialisers = new ArrayList();
        worldMap = new HashMap();
    }

    public static class WorldExtensionEventHandler {
        @SubscribeEvent
        public void onChunkDataLoad(ChunkDataEvent.Load event) {
            if (!worldMap.containsKey(event.getWorld())) {
                WorldExtensionManager.onWorldLoad(event.getWorld());
            }
            WorldExtensionManager.createChunkExtension(event.getWorld(), event.getChunk());
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.getWorld())) {
                extension.loadChunkData(event.getChunk(), event.getData());
            }
        }

        @SubscribeEvent
        public void onChunkDataSave(ChunkDataEvent.Save event) {
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.getWorld())) {
                extension.saveChunkData(event.getChunk(), event.getData());
            }
            if (!event.getChunk().func_177410_o()) {
                WorldExtensionManager.removeChunk(event.getWorld(), event.getChunk());
            }
        }

        @SubscribeEvent
        public void onChunkLoad(ChunkEvent.Load event) {
            if (!worldMap.containsKey(event.getWorld())) {
                WorldExtensionManager.onWorldLoad(event.getWorld());
            }
            WorldExtensionManager.createChunkExtension(event.getWorld(), event.getChunk());
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.getWorld())) {
                extension.loadChunk(event.getChunk());
            }
        }

        @SubscribeEvent
        public void onChunkUnLoad(ChunkEvent.Unload event) {
            if (event.getChunk().func_76621_g()) {
                return;
            }
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.getWorld())) {
                extension.unloadChunk(event.getChunk());
            }
            if (event.getWorld().field_72995_K) {
                WorldExtensionManager.removeChunk(event.getWorld(), event.getChunk());
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (worldMap.containsKey(event.getWorld())) {
                for (WorldExtension extension : (WorldExtension[])worldMap.get(event.getWorld())) {
                    extension.save();
                }
            }
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (!worldMap.containsKey(event.getWorld())) {
                WorldExtensionManager.onWorldLoad(event.getWorld());
            }
        }

        @SubscribeEvent
        public void onWorldUnLoad(WorldEvent.Unload event) {
            if (worldMap.containsKey(event.getWorld())) {
                for (WorldExtension extension : (WorldExtension[])worldMap.remove(event.getWorld())) {
                    extension.unload();
                }
            }
        }

        @SubscribeEvent
        public void onChunkWatch(ChunkWatchEvent.Watch event) {
            Chunk chunk = event.getPlayer().field_70170_p.func_72964_e(event.getChunk().field_77276_a, event.getChunk().field_77275_b);
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.getPlayer().field_70170_p)) {
                extension.watchChunk(chunk, event.getPlayer());
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
            Chunk chunk = event.getPlayer().field_70170_p.func_72964_e(event.getChunk().field_77276_a, event.getChunk().field_77275_b);
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.getPlayer().field_70170_p)) {
                extension.unwatchChunk(chunk, event.getPlayer());
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void clientTick(TickEvent.ClientTickEvent event) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (worldMap.containsKey(world)) {
                if (event.phase == TickEvent.Phase.START) {
                    WorldExtensionManager.preTick((World)world);
                } else {
                    WorldExtensionManager.postTick((World)world);
                }
            }
        }

        @SubscribeEvent
        public void serverTick(TickEvent.WorldTickEvent event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            if (event.phase == TickEvent.Phase.START) {
                WorldExtensionManager.preTick(event.world);
            } else {
                WorldExtensionManager.postTick(event.world);
            }
        }
    }
}

