/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.common.entity.EntityGuiItem;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;
import shetiphian.platforms.common.inventory.InventoryPlatFormer;

public class TileEntityPlatFormer
extends TileEntityBase
implements ISidedWrapper,
ISidedInventory,
IOutputSlot,
ITickable {
    public InventoryInternal inventory;
    private ISidedWrapper.SidedWrapper sidedWrapper;
    public byte platformType = 0;
    private ItemStack[] deconstructCache = new ItemStack[4];
    private byte[] craftAmount = new byte[]{4, 2, 4, 2, 4, 4};
    private EntityGuiItem displayItem = null;
    private ItemStack outputItem;

    public TileEntityPlatFormer() {
        this.inventory = new InventoryPlatFormer(this);
        InventoryPlatFormer inv = (InventoryPlatFormer)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(), inv.getWrapperDeconstruct(), inv.getWrapperOutput(), inv.getWrapperStorage()});
        this.sidedWrapper.setLatency((int[][])new int[][]{inv.SLOTS_BASIC, inv.SLOTS_DECON, inv.SLOTS_OUTPUT, inv.SLOTS_STORAGE});
        this.sidedWrapper.setFaceIndex(EnumFacing.DOWN, 2);
        this.sidedWrapper.setFaceIndex(EnumFacing.UP, 3);
        this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 0);
    }

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("type", this.platformType);
        this.inventory.writeToNBT(nbtTag, "items");
        this.sidedWrapper.writeToNBT(nbtTag);
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.platformType = nbtTag.func_74771_c("type");
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "inventory");
        this.sidedWrapper.readFromNBT(nbtTag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.sidedWrapper.getWrapper(EnumFacing.SOUTH, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.sidedWrapper.getWrapper(EnumFacing.SOUTH, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public ISidedWrapper.SidedWrapper getSidedWrapper() {
        return this.sidedWrapper;
    }

    public void func_73660_a() {
        byte needed;
        ItemStack deconStack;
        if (this.outputItem == null) {
            this.updateOutput();
        }
        if ((deconStack = this.inventory.func_70301_a(5)) != null && deconStack.field_77994_a >= (needed = this.getCraftedAmount(deconStack))) {
            this.deconstruct(needed);
        }
    }

    private void deconstruct(int needed) {
        ItemStack deconStack = this.inventory.func_70301_a(5);
        if (deconStack == null) {
            return;
        }
        if (!Function.areItemStacksEqual((ItemStack)this.deconstructCache[0], (ItemStack)deconStack)) {
            this.deconstructCache[0] = deconStack;
            NBTTagCompound nbtTag = deconStack.func_77978_p();
            if (nbtTag != null && nbtTag.func_74764_b("texture1") && nbtTag.func_74764_b("texture2")) {
                this.deconstructCache[1] = CraftHelper.getDeconStack(nbtTag.func_74779_i("texture1"));
                this.deconstructCache[2] = CraftHelper.getDeconStack(nbtTag.func_74779_i("texture2"));
            }
        }
        if (this.deconstructCache[1] == null || this.deconstructCache[2] == null) {
            return;
        }
        int[] slots = new int[]{-1, -1};
        HashMap<Byte, ItemStack> changes = new HashMap<Byte, ItemStack>();
        block0: for (int item = 0; item < 2; item = (int)((byte)(item + 1))) {
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (byte slot = 6; slot < 15; slot = (byte)((byte)(slot + 1))) {
                    ItemStack stack;
                    ItemStack itemStack = stack = changes.containsKey(slot) ? (ItemStack)changes.get(slot) : this.inventory.getContents()[slot];
                    if (stack != null) {
                        if (stack.field_77994_a >= stack.func_77976_d() || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)this.deconstructCache[1 + item])) continue;
                        slots[item] = slot;
                        stack = stack.func_77946_l();
                        ++stack.field_77994_a;
                        changes.put(slot, stack);
                        continue block0;
                    }
                    if (pass != 1) continue;
                    slots[item] = slot;
                    changes.put(slot, this.deconstructCache[1 + item].func_77946_l());
                    continue block0;
                }
            }
        }
        if (slots[0] > -1 && slots[1] > -1) {
            for (Map.Entry entry : changes.entrySet()) {
                this.inventory.getContents()[((Byte)entry.getKey()).byteValue()] = (ItemStack)entry.getValue();
            }
            if (deconStack.field_77994_a - needed < 1) {
                deconStack = null;
            } else {
                deconStack.field_77994_a -= needed;
            }
            this.inventory.func_70299_a(5, deconStack);
            this.func_70296_d();
        }
    }

    public void dropItems() {
        for (int slotId = 4; slotId < this.inventory.getContents().length; ++slotId) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)this.inventory.func_70301_a(slotId));
        }
    }

    private byte getCraftedAmount(ItemStack stack) {
        int type = stack.func_77952_i() % 10;
        if (type < this.craftAmount.length) {
            return this.craftAmount[type];
        }
        return 0;
    }

    public void updateOutput() {
        ItemStack matStack = this.inventory.func_70301_a(0);
        int material = matStack == null || CraftHelper.isPlanks(matStack) ? 0 : (CraftHelper.isMetal(this.inventory.func_70301_a(0)) ? 20 : 10);
        EnumHelper.EnumPlatform enumplatform = EnumHelper.getPlatform(material, this.platformType % 10);
        this.setGhostSlot(0, this.inventory.func_70301_a(0));
        this.setGhostSlot(1, this.inventory.func_70301_a(1));
        this.outputItem = PlatformHelper.getStack(enumplatform, this.inventory.func_70301_a(1), this.inventory.func_70301_a(0));
        if (this.outputItem != null) {
            this.outputItem.field_77994_a = this.getCraftedAmount(this.outputItem);
            ItemStack displaystack = this.outputItem.func_77946_l();
            displaystack.func_77964_b(displaystack.func_77952_i());
            displaystack.field_77994_a = 1;
            this.displayItem = new EntityGuiItem(this.func_145831_w(), 0.0, 0.0, 0.0, displaystack);
            if (this.inventory.func_70301_a(0) == null || this.inventory.func_70301_a(1) == null) {
                this.inventory.func_70299_a(3, null);
            } else {
                this.inventory.func_70299_a(3, this.outputItem.func_77946_l());
            }
        }
    }

    public EntityGuiItem getEntity() {
        if (this.displayItem == null) {
            this.updateOutput();
        }
        return this.displayItem;
    }

    public boolean canCraft() {
        ItemStack[] craftStacks = CraftHelper.getCraftStacks(EnumHelper.getMaterial(this.platformType), this.inventory.func_70301_a(0), this.inventory.func_70301_a(1));
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            if (stack == null) continue;
            if (!hasItem[0] && Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[0])) {
                hasItem[0] = true;
                if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)craftStacks[0], (ItemStack)craftStacks[1]) || stack.field_77994_a <= 1) continue;
                hasItem[1] = true;
            }
            if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[1])) continue;
            hasItem[1] = true;
        }
        return hasItem[0] && hasItem[1];
    }

    public void doCraft() {
        ItemStack[] craftStacks = CraftHelper.getCraftStacks(EnumHelper.getMaterial(this.platformType), this.inventory.func_70301_a(0), this.inventory.func_70301_a(1));
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            if (stack == null) continue;
            for (int part = 0; part < 2; part = (int)((byte)(part + 1))) {
                if (hasItem[part] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[part])) continue;
                hasItem[part] = true;
                if (stack.field_77994_a == 1) {
                    this.inventory.func_70299_a(slot, null);
                    continue;
                }
                --stack.field_77994_a;
                this.inventory.func_70299_a(slot, stack);
            }
        }
    }

    public void setGhostSlot(int slotId, ItemStack stack) {
        if (stack == null) {
            if (slotId >= 0 && slotId < 3) {
                this.inventory.func_70299_a(slotId, null);
            }
            return;
        }
        boolean itemOK = false;
        if (slotId == 0 || slotId == 1) {
            boolean bl = itemOK = CraftHelper.isPlanks(stack) || CraftHelper.isStone(stack) || CraftHelper.isMetal(stack);
        }
        if (itemOK) {
            this.inventory.func_70299_a(slotId, stack.func_77946_l().func_77979_a(1));
        } else {
            this.inventory.func_70299_a(slotId, null);
        }
    }

    public boolean canTakeFromOutputSlot(int slotId, EntityPlayer player) {
        return slotId != 3 || player.field_71075_bZ.field_75098_d || this.canCraft();
    }

    public ItemStack decrStackSize(int slotId, EntityPlayer player, int amount) {
        ItemStack stack;
        if (slotId == 3 && player.field_71075_bZ.field_75098_d && (stack = this.inventory.func_70301_a(3)) != null) {
            stack = stack.func_77946_l();
            stack.field_77994_a = 64;
            return stack;
        }
        return null;
    }

    public void onPickupFromOutputSlot(int slotId, EntityPlayer player, ItemStack stack) {
    }

    public ItemStack getOutputItem() {
        return this.outputItem != null ? this.outputItem.func_77946_l() : null;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        return this.inventory.func_70298_a(slotId, amount);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inventory.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        this.inventory.func_70299_a(slotId, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return this.inventory.func_94041_b(slotId, stack);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int[] func_180463_a(EnumFacing face) {
        return this.sidedWrapper.getLatency(EnumFacing.SOUTH, face);
    }

    public boolean func_180462_a(int slotId, ItemStack stack, EnumFacing face) {
        if (stack != null) {
            int[] latency = this.func_180463_a(face);
            for (int index = 0; index < latency.length; ++index) {
                InvWrapper wrapper;
                if (slotId != latency[index] || (wrapper = this.sidedWrapper.getWrapper(EnumFacing.SOUTH, face)) == null) continue;
                return wrapper.insertItem(index, stack, true) != stack;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slotId, ItemStack stack, EnumFacing face) {
        if (stack != null) {
            int[] latency = this.func_180463_a(face);
            for (int index = 0; index < latency.length; ++index) {
                InvWrapper wrapper;
                if (slotId != latency[index] || (wrapper = this.sidedWrapper.getWrapper(EnumFacing.SOUTH, face)) == null) continue;
                return wrapper.extractItem(index, stack.field_77994_a, true) != null;
            }
        }
        return false;
    }
}

