/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.common.data;

import java.io.Serializable;
import javax.annotation.Nonnull;

public class Element
implements Serializable {
    private static final long serialVersionUID = -6961457157774225518L;
    public String text;
    public boolean state;
    public boolean isAchievement = false;
    public int color = 0;
    public int height = 30;
    public int colorChecked = 36880;
    public static final String lineSplit = "|";
    public Alignment align = Alignment.LEFT;
    public boolean shadow = false;

    public Element() {
    }

    public Element(String text) {
        this.text = text;
    }

    public Element(Element other) {
        if (other != null) {
            this.text = other.text;
            this.state = other.state;
            this.isAchievement = other.isAchievement;
            this.color = other.color;
            this.height = other.height;
            this.colorChecked = other.colorChecked;
            this.align = other.align;
            this.shadow = other.shadow;
        }
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean newState) {
        this.state = newState;
    }

    public void toggle() {
        this.state = !this.state;
    }

    public boolean isAchievement() {
        return this.isAchievement;
    }

    public int getColor() {
        return this.color;
    }

    public int getCheckedColor() {
        return this.colorChecked;
    }

    public int getBaseHeight() {
        return this.height;
    }

    public Alignment getAlign() {
        return this.align;
    }

    @Nonnull
    public String getText() {
        return this.text.replace(lineSplit, "\n");
    }

    public void setText(String s) {
        this.text = s;
    }

    public int getColorBasedOnState() {
        return this.getState() ? this.colorChecked : this.color;
    }

    public String toString() {
        return "Element(text=" + this.getText() + ", state=" + this.getState() + ", isAchievement=" + this.isAchievement() + ", color=" + this.getColor() + ", height=" + this.height + ", colorChecked=" + this.colorChecked + ", align=" + (Object)((Object)this.getAlign()) + ", shadow=" + this.shadow + ")";
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

