/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.wyldmods.simpleachievements.SimpleAchievements;
import org.wyldmods.simpleachievements.client.gui.GuiHelper;
import org.wyldmods.simpleachievements.common.NBTUtils;
import org.wyldmods.simpleachievements.common.TileEntityAchievementStand;

public class BlockAchievementStand
extends Block
implements ITileEntityProvider {
    @Nonnull
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    @Nonnull
    public static final PropertyBool HAS_BOOK = PropertyBool.func_177716_a((String)"has_book");

    public BlockAchievementStand() {
        super(Material.field_151575_d);
        this.func_149663_c("sa.achievementTable");
        this.setRegistryName("achievement_stand");
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HAS_BOOK, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HAS_BOOK});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_BOOK) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_BOOK, (Comparable)Boolean.valueOf(meta == 0));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityAchievementStand stand = (TileEntityAchievementStand)world.func_175625_s(pos);
        if (stand == null) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)HAS_BOOK)).booleanValue()) {
            if (player.func_70093_af()) {
                ItemStack bookToAdd = new ItemStack(SimpleAchievements.achievementBook);
                NBTTagCompound bookTag = NBTUtils.getTag(bookToAdd);
                bookTag.func_74768_a("sa:page", stand.page);
                bookToAdd.func_77982_d(bookTag);
                player.field_71071_by.func_70441_a(bookToAdd);
                world.func_175656_a(pos, state.func_177226_a((IProperty)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
            } else if (world.field_72995_K) {
                GuiHelper.openSAGUI(world, player, pos);
            }
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack != null && stack.func_77973_b() == SimpleAchievements.achievementBook) {
            NBTTagCompound bookTag = NBTUtils.getTag(stack);
            stand.page = bookTag.func_74762_e("sa:page");
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            world.func_175656_a(pos, state.func_177226_a((IProperty)HAS_BOOK, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityAchievementStand();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }
}

