/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.wyldmods.simpleachievements.SimpleAchievements;
import org.wyldmods.simpleachievements.client.gui.ButtonElement;
import org.wyldmods.simpleachievements.common.NBTUtils;
import org.wyldmods.simpleachievements.common.TileEntityAchievementStand;
import org.wyldmods.simpleachievements.common.data.DataHandler;
import org.wyldmods.simpleachievements.common.data.DataManager;
import org.wyldmods.simpleachievements.common.data.Element;
import org.wyldmods.simpleachievements.common.networking.MessageAchievement;
import org.wyldmods.simpleachievements.common.networking.PacketHandlerSA;

public class GuiSA
extends GuiScreen {
    private Origin origin;
    @Nonnull
    private EnumHand hand = EnumHand.MAIN_HAND;
    private final int maxDelay = 5;
    private int clickDelay = 5;
    public static final int GUI_ID = 20;
    private DataHandler elements;
    private int page;
    private int startX;
    private int startY = 2;
    private int startYAch = 15;
    private List<Integer> pages;
    private int charHeight = 8;
    private TileEntityAchievementStand stand;
    @Nonnull
    private static final ResourceLocation bgl = new ResourceLocation("SimpleAchievements".toLowerCase() + ":textures/gui/bookgui_left.png");
    @Nonnull
    private static final ResourceLocation bgr = new ResourceLocation("SimpleAchievements".toLowerCase() + ":textures/gui/bookgui_right.png");

    public GuiSA(EntityPlayer player, @Nonnull EnumHand hand) {
        this(player, NBTUtils.getTag(player.func_184586_b(hand)).func_74762_e("sa:page"));
        this.origin = Origin.ITEM;
        this.hand = hand;
    }

    public GuiSA(EntityPlayer player, TileEntityAchievementStand par2stand) {
        this(player, par2stand.page);
        this.origin = Origin.BLOCK;
        this.stand = par2stand;
    }

    public GuiSA(EntityPlayer player, int par1Page) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.elements = DataManager.INSTANCE.getHandlerFor(player.func_70005_c_());
        this.page = par1Page;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.pages == null) {
            this.initPages();
        }
        this.clickDelay = 5;
        this.field_146292_n.clear();
        int idx = this.getIndex();
        this.getNextButtons(idx, this.field_146292_n);
        this.field_146292_n.add(new ButtonPage(this.elements.numElements(), this.startX + SimpleAchievements.bookWidth - 22, this.startY + SimpleAchievements.bookHeight - 23, true));
        this.field_146292_n.add(new ButtonPage(this.elements.numElements() + 1, this.startX, this.startY + SimpleAchievements.bookHeight - 23, false));
    }

    private int getIndex() {
        if (this.pages.size() <= 0) {
            this.field_146297_k.field_71439_g.func_71053_j();
            this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("No achievements found - check file encoding."));
            return -1;
        }
        if (this.page >= this.pages.size()) {
            --this.page;
            return this.getIndex();
        }
        if (this.page < 0) {
            this.page = 0;
            return this.getIndex();
        }
        return this.pages.get(this.page);
    }

    private void initPages() {
        ArrayList mockList = Lists.newArrayList();
        this.pages = new ArrayList<Integer>();
        int idx = 0;
        while (idx < this.elements.numElements()) {
            this.pages.add(idx);
            idx = this.getNextButtons(idx, mockList);
        }
    }

    private int getNextButtons(int startIndex, List<GuiButton> buttons) {
        int height;
        int yPos;
        ButtonElement button;
        if (startIndex < 0) {
            return startIndex;
        }
        int baseHeight = 30;
        int width = SimpleAchievements.bookWidth / 2 - 60;
        Element[] chievs = this.elements.getAchievementArr();
        for (yPos = this.startYAch; startIndex < chievs.length && yPos < SimpleAchievements.bookHeight - (height = baseHeight + ButtonElement.getExpectedLines(chievs[startIndex], width) * this.charHeight); yPos += button.getHeight(), ++startIndex) {
            button = new ButtonElement(startIndex, this.startX + 25, this.startY + yPos, width, chievs[startIndex], this);
            buttons.add(button);
        }
        for (yPos = this.startYAch; startIndex < chievs.length && yPos < SimpleAchievements.bookHeight - (height = baseHeight + ButtonElement.getExpectedLines(chievs[startIndex], width) * this.charHeight); yPos += button.getHeight(), ++startIndex) {
            button = new ButtonElement(startIndex, this.startX + 10 + SimpleAchievements.bookWidth / 2, this.startY + yPos, width, chievs[startIndex], this);
            buttons.add(button);
        }
        return startIndex;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        this.clickDelay = Math.max(0, this.clickDelay - 1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int newX = (this.field_146294_l - SimpleAchievements.bookWidth) / 2;
        int newY = (int)((double)(this.field_146295_m - SimpleAchievements.bookHeight) / 2.5);
        if (this.startX != newX || this.startY != newY) {
            this.startX = newX;
            this.startY = newY;
            this.func_73866_w_();
        }
        this.field_146297_k.func_110434_K().func_110577_a(bgl);
        this.func_73729_b(this.startX, this.startY, 0, 0, SimpleAchievements.bookWidth / 2, SimpleAchievements.bookHeight);
        this.field_146297_k.func_110434_K().func_110577_a(bgr);
        this.func_73729_b(this.startX + SimpleAchievements.bookWidth / 2, this.startY, 0, 0, SimpleAchievements.bookWidth / 2, SimpleAchievements.bookHeight);
        super.func_73863_a(mouseX, mouseY, par3);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k < this.elements.numElements()) {
            this.toggleAchievement(button.field_146127_k);
        } else if (this.clickDelay == 0) {
            if (button.field_146127_k == this.elements.numElements()) {
                this.incrPage();
            } else if (button.field_146127_k == this.elements.numElements() + 1) {
                this.decrPage();
            }
        }
    }

    private void toggleAchievement(int id) {
        this.elements.toggleAchievement(id);
        PacketHandlerSA.INSTANCE.sendToServer((IMessage)new MessageAchievement(id, this.elements.getAchievementState(id)));
    }

    private void incrPage() {
        ++this.page;
        this.setNBT();
        this.func_73866_w_();
    }

    private void decrPage() {
        this.page = this.page == 0 ? 0 : this.page - 1;
        this.setNBT();
        this.func_73866_w_();
    }

    private void setNBT() {
        switch (this.origin) {
            case BLOCK: {
                this.stand.page = this.page;
                PacketHandlerSA.INSTANCE.sendToServer((IMessage)new MessageAchievement(this.stand.page, this.stand.func_174877_v()));
                break;
            }
            case ITEM: {
                EntityPlayerSP player = this.field_146297_k.field_71439_g;
                NBTUtils.getTag(player.func_184586_b(this.hand)).func_74768_a("sa:page", this.page);
                PacketHandlerSA.INSTANCE.sendToServer((IMessage)new MessageAchievement(this.page, this.hand));
            }
        }
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.field_146297_k = par1Minecraft;
        this.field_146289_q = par1Minecraft.field_71466_p;
        this.field_146294_l = par2;
        this.field_146295_m = par3;
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    public boolean func_73868_f() {
        return false;
    }

    private class ButtonPage
    extends GuiButton {
        private boolean next;

        public ButtonPage(int id, int x, int y, boolean next) {
            super(id, x, y, 21, 21, next ? "next" : "prev");
            this.next = next;
        }

        public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
            if (this.field_146125_m) {
                par1Minecraft.func_110434_K().func_110577_a(ButtonElement.texture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean hover = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.next ? 234 : 203, hover ? 211 : 233, this.field_146120_f, this.field_146121_g);
                this.func_146119_b(par1Minecraft, par2, par3);
            }
        }

        public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
            if (GuiSA.this.clickDelay <= 0) {
                return super.func_146116_c(par1Minecraft, par2, par3);
            }
            return false;
        }
    }

    public static enum Origin {
        ITEM,
        BLOCK;

    }
}

