/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic;

import java.util.List;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;

public class PluginEnchantmentPower
extends InfoProvider {
    private static boolean enabled = true;

    @Override
    public void addTileInfo(List<String> info, InfoAccess data) {
        float enchPower;
        if (enabled && (enchPower = data.block.getEnchantPowerBonus(data.world, data.pos)) > 0.0f) {
            info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.enchpower", (Object[])new Object[0]) + ": " + enchPower);
        }
    }

    @Override
    public void addItemInfo(List<String> info, ItemStack stack, boolean advanced, EntityPlayer entityPlayer) {
        Block block;
        if (enabled && (block = Block.func_149634_a((Item)stack.func_77973_b())) != null) {
            try {
                float enchPower = block.getEnchantPowerBonus(entityPlayer.field_70170_p, BlockPos.field_177992_a);
                if (enchPower > 0.0f) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.enchPower", (Object[])new Object[0]) + ": " + enchPower);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        enabled = config.getBoolean("EnchantPower", "generic_tiles", true, "If this is enabled, the hud will display the enchant power of a block while looking at it.");
    }
}

