/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.HarvestLevels;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerTools;

public class Mattock
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials_axe = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151570_A, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151572_C);
    public static final ImmutableSet<Material> effective_materials_shovel = ImmutableSet.of((Object)Material.field_151577_b, (Object)Material.field_151578_c, (Object)Material.field_151571_B);

    public Mattock() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.axeHead), PartMaterialType.head(TinkerTools.shovelHead));
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("mattock", 0);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, @Nonnull String toolClass) {
        if (toolClass == null) {
            return -1;
        }
        if (toolClass.equals("axe")) {
            return this.getAxeLevel(stack);
        }
        if (toolClass.equals("shovel")) {
            return this.getShovelLevel(stack);
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    @Override
    public boolean isEffective(IBlockState state) {
        return effective_materials_axe.contains((Object)state.func_185904_a()) || effective_materials_shovel.contains((Object)state.func_185904_a());
    }

    @Override
    public float miningSpeedModifier() {
        return 0.95f;
    }

    @Override
    public float damagePotential() {
        return 0.9f;
    }

    @Override
    public float knockback() {
        return 1.1f;
    }

    @Override
    public double attackSpeed() {
        return 0.9f;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ToolHelper.isBroken(stack)) {
            return EnumActionResult.FAIL;
        }
        EnumActionResult ret = this.useHoe(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        for (BlockPos blockPos : this.getAOEBlocks(stack, worldIn, playerIn, pos)) {
            if (ToolHelper.isBroken(stack)) break;
            EnumActionResult ret2 = this.useHoe(stack, playerIn, worldIn, blockPos, hand, facing, hitX, hitY, hitZ);
            if (ret == EnumActionResult.SUCCESS) continue;
            ret = ret2;
        }
        if (ret == EnumActionResult.SUCCESS) {
            TinkerToolEvent.OnMattockHoe.fireEvent(stack, playerIn, worldIn, pos);
        }
        return ret;
    }

    private EnumActionResult useHoe(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos blockPos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int damage = stack.func_77952_i();
        EnumActionResult ret = Items.field_151012_L.func_180614_a(stack, playerIn, worldIn, blockPos, hand, facing, hitX, hitY, hitZ);
        stack.func_77964_b(damage);
        if (!worldIn.field_72995_K && ret == EnumActionResult.SUCCESS) {
            ToolHelper.damageTool(stack, 1, (EntityLivingBase)playerIn);
        }
        return ret;
    }

    @Override
    public boolean isAoeHarvestTool() {
        return false;
    }

    @Override
    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        String text = Util.translate("stat.mattock.axelevel.name", new Object[0]);
        info.add(String.format("%s: %s", text, HarvestLevels.getHarvestLevelName(this.getAxeLevel(stack))) + TextFormatting.RESET);
        text = Util.translate("stat.mattock.shovellevel.name", new Object[0]);
        info.add(String.format("%s: %s", text, HarvestLevels.getHarvestLevelName(this.getShovelLevel(stack))) + TextFormatting.RESET);
        info.addMiningSpeed();
        info.addAttack();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    public ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats axe = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats shovel = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        MattockToolNBT data = new MattockToolNBT();
        data.head(axe, shovel);
        data.handle(handle);
        data.axeLevel = axe.harvestLevel;
        data.shovelLevel = shovel.harvestLevel;
        data.attack += 3.0f;
        return data;
    }

    protected int getAxeLevel(ItemStack stack) {
        return new MattockToolNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)stack)).axeLevel;
    }

    protected int getShovelLevel(ItemStack stack) {
        return new MattockToolNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)stack)).shovelLevel;
    }

    public static class MattockToolNBT
    extends ToolNBT {
        private static final String TAG_AxeLevel = "HarvestLevelAxe";
        private static final String TAG_ShovelLevel = "HarvestLevelShovel";
        public int axeLevel;
        public int shovelLevel;

        public MattockToolNBT() {
        }

        public MattockToolNBT(NBTTagCompound tag) {
            super(tag);
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.axeLevel = tag.func_74762_e(TAG_AxeLevel);
            this.shovelLevel = tag.func_74762_e(TAG_ShovelLevel);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a(TAG_AxeLevel, this.axeLevel);
            tag.func_74768_a(TAG_ShovelLevel, this.shovelLevel);
        }
    }
}

