/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.item.BoltCore;

public class BoltCoreCastingRecipe
implements ICastingRecipe {
    public static final BoltCoreCastingRecipe INSTANCE = new BoltCoreCastingRecipe();
    public static final int boltCoreAmount = 288;

    protected BoltCoreCastingRecipe() {
    }

    @Override
    public ItemStack getResult(@Nullable ItemStack cast, Fluid fluid) {
        Material shaftMaterial = TinkerTools.arrowShaft.getMaterial(cast);
        Material headMaterial = this.getMaterialForFluid(fluid);
        return BoltCore.getItemstackWithMaterials(shaftMaterial, headMaterial);
    }

    private Material getMaterialForFluid(Fluid fluid) {
        return TinkerRegistry.getAllMaterials().stream().filter(mat -> fluid.equals(mat.getFluid())).findFirst().orElse(Material.UNKNOWN);
    }

    @Override
    public boolean matches(@Nullable ItemStack cast, Fluid fluid) {
        return cast != null && cast.func_77973_b() == TinkerTools.arrowShaft && TinkerTools.arrowShaft.getMaterial(cast).hasStats("shaft") && this.isFluidWithHeadMaterial(fluid);
    }

    private boolean isFluidWithHeadMaterial(Fluid fluid) {
        return TinkerRegistry.getAllMaterials().stream().filter(mat -> mat.hasStats("head")).map(Material::getFluid).anyMatch(fluid::equals);
    }

    @Override
    public boolean switchOutputs() {
        return false;
    }

    @Override
    public boolean consumesCast() {
        return true;
    }

    @Override
    public int getTime() {
        return 120;
    }

    @Override
    public int getFluidAmount() {
        return 288;
    }
}

