/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.material.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.IPatternOffset;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;
import slimeknights.tconstruct.library.client.texture.CastTexture;
import slimeknights.tconstruct.library.client.texture.GuiOutlineTexture;
import slimeknights.tconstruct.library.client.texture.PatternTexture;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.MaterialGUI;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;

public class CustomTextureCreator
implements IResourceManagerReloadListener {
    public static final CustomTextureCreator INSTANCE = new CustomTextureCreator();
    private static Logger log = Util.getLogger("TextureGen");
    public static Map<String, Map<String, TextureAtlasSprite>> sprites = Maps.newHashMap();
    private static Set<ResourceLocation> baseTextures = Sets.newHashSet();
    private static Map<ResourceLocation, Set<IToolPart>> texturePartMapping = Maps.newHashMap();
    public static ResourceLocation patternModelLocation;
    public static ResourceLocation castModelLocation;
    public static String patternLocString;
    public static String castLocString;
    public static final Material guiMaterial;
    private int createdTextures;

    public static void registerTextures(Collection<ResourceLocation> textures) {
        baseTextures.addAll(textures);
    }

    public static void registerTexture(ResourceLocation texture) {
        baseTextures.add(texture);
    }

    public static void registerTextureForPart(ResourceLocation texture, IToolPart toolPart) {
        if (!texturePartMapping.containsKey(texture)) {
            texturePartMapping.put(texture, Sets.newHashSet());
        }
        texturePartMapping.get(texture).add(toolPart);
        CustomTextureCreator.registerTexture(texture);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void createCustomTextures(TextureStitchEvent.Pre event) {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return;
        }
        MaterialRenderInfoLoader.INSTANCE.loadRenderInfo();
        this.createdTextures = 0;
        this.createMaterialTextures(event.getMap());
        this.createPatterntextures(event.getMap());
        log.debug("Generated " + this.createdTextures + " Textures for Materials");
    }

    private void createMaterialTextures(TextureMap map) {
        for (ResourceLocation baseTexture : baseTextures) {
            TextureAtlasSprite sprite;
            if (baseTexture.toString().equals("minecraft:missingno")) continue;
            TextureAtlasSprite base = map.getTextureExtry(baseTexture.toString());
            if (base == null) {
                log.error("Missing base texture: " + baseTexture.toString());
                continue;
            }
            Set<IToolPart> parts = texturePartMapping.get(baseTexture);
            HashMap builtSprites = Maps.newHashMap();
            for (Material material : TinkerRegistry.getAllMaterials()) {
                TextureAtlasSprite sprite2;
                boolean usable;
                if (parts == null || material instanceof MaterialGUI) {
                    usable = true;
                } else {
                    usable = false;
                    for (IToolPart toolPart : parts) {
                        usable |= toolPart.canUseMaterial(material);
                    }
                }
                if (!usable || (sprite2 = this.createTexture(material, baseTexture, base, map)) == null) continue;
                builtSprites.put(material.identifier, sprite2);
            }
            if (CustomTextureCreator.belongsToToolPart(baseTexture) && (sprite = this.createTexture(guiMaterial, baseTexture, base, map)) != null) {
                builtSprites.put(CustomTextureCreator.guiMaterial.identifier, sprite);
            }
            sprites.put(baseTexture.toString(), builtSprites);
        }
    }

    private TextureAtlasSprite createTexture(Material material, ResourceLocation baseTexture, TextureAtlasSprite base, TextureMap map) {
        TextureAtlasSprite sprite;
        String location = baseTexture.toString() + "_" + material.identifier;
        if (CustomTextureCreator.exists(location)) {
            sprite = map.func_174942_a(new ResourceLocation(location));
        } else {
            if (material.renderInfo == null) {
                return null;
            }
            TextureAtlasSprite matBase = base;
            if (material.renderInfo.getTextureSuffix() != null) {
                String loc2 = baseTexture.toString() + "_" + material.renderInfo.getTextureSuffix();
                TextureAtlasSprite base2 = map.getTextureExtry(loc2);
                if (base2 == null && CustomTextureCreator.exists(loc2)) {
                    base2 = new AbstractColoredTexture(loc2, loc2){

                        @Override
                        protected int colorPixel(int pixel, int mipmap, int pxCoord) {
                            return pixel;
                        }
                    };
                    map.setTextureEntry(loc2, base2);
                }
                if (base2 != null) {
                    matBase = base2;
                }
            }
            sprite = material.renderInfo.getTexture(matBase, location);
            ++this.createdTextures;
        }
        if (sprite != null && material.renderInfo.isStitched()) {
            map.setTextureEntry(location, sprite);
        }
        return sprite;
    }

    private void createPatterntextures(TextureMap map) {
        if (patternModelLocation != null) {
            patternLocString = this.createPatternTexturesFor(map, patternModelLocation, TinkerRegistry.getPatternItems(), PatternTexture.class);
        }
        if (castModelLocation != null) {
            castLocString = this.createPatternTexturesFor(map, castModelLocation, TinkerRegistry.getCastItems(), CastTexture.class);
        }
    }

    public String createPatternTexturesFor(TextureMap map, ResourceLocation baseTextureLoc, Iterable<Item> items, Class<? extends TextureColoredTexture> clazz) {
        String baseTextureString;
        TextureAtlasSprite baseTexture;
        Constructor<? extends TextureColoredTexture> constructor;
        try {
            constructor = clazz.getConstructor(String.class, TextureAtlasSprite.class, String.class);
            IModel patternModel = ModelLoaderRegistry.getModel((ResourceLocation)baseTextureLoc);
            ResourceLocation patternLocation = (ResourceLocation)patternModel.getTextures().iterator().next();
            baseTexture = map.getTextureExtry(patternLocation.toString());
            baseTextureString = patternLocation.toString();
            if (baseTexture == null) {
                log.error("No basetexture found for pattern texture generation: " + patternLocation);
                return null;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
        for (Item item : items) {
            try {
                TextureAtlasSprite partPatternTexture;
                String identifier = Pattern.getTextureIdentifier(item);
                String partPatternLocation = baseTextureString + identifier;
                if (CustomTextureCreator.exists(partPatternLocation)) {
                    partPatternTexture = map.func_174942_a(new ResourceLocation(partPatternLocation));
                    map.setTextureEntry(partPatternLocation, partPatternTexture);
                    continue;
                }
                ResourceLocation modelLocation = Util.getItemLocation(item);
                IModel partModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "item/parts/" + modelLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
                ResourceLocation partTexture = (ResourceLocation)partModel.getTextures().iterator().next();
                if (partModel == ModelLoaderRegistry.getMissingModel()) continue;
                partPatternTexture = constructor.newInstance(partTexture.toString(), baseTexture, partPatternLocation);
                if (partModel instanceof IPatternOffset) {
                    IPatternOffset offset = (IPatternOffset)partModel;
                    ((TextureColoredTexture)partPatternTexture).setOffset(offset.getXOffset(), offset.getYOffset());
                }
                map.setTextureEntry(partPatternLocation, partPatternTexture);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return baseTextureString;
    }

    private ResourceLocation getModelLocationForItem(Item item) {
        String loc = null;
        try {
            Field field = ModelBakery.class.getDeclaredField("customVariantNames");
            field.setAccessible(true);
            Map map = (Map)field.get(null);
            Set variants = (Set)map.get(item.delegate);
            if (variants != null) {
                loc = (String)variants.iterator().next();
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (loc == null) {
            loc = Util.getItemLocation(item).toString();
        }
        ResourceLocation rl = new ResourceLocation(loc.replaceAll("#.*", ""));
        rl = new ResourceLocation(rl.func_110624_b(), "item/" + rl.func_110623_a());
        return rl;
    }

    private void createGUITextures(TextureMap map) {
        for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
            if (!(toolpart instanceof Item)) continue;
            try {
                ResourceLocation modelLocation = Util.getItemLocation((Item)toolpart);
                IModel partModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "item/parts/" + modelLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
                ResourceLocation baseTexture = (ResourceLocation)partModel.getTextures().iterator().next();
                TextureAtlasSprite base = map.getTextureExtry(baseTexture.toString());
                if (base == null) {
                    log.error("Missing base texture: " + baseTexture.toString());
                    continue;
                }
                Map<String, TextureAtlasSprite> partTextures = sprites.get(baseTexture.toString());
                if (partTextures == null) continue;
                String location = baseTexture.toString() + "_internal_gui";
                GuiOutlineTexture outlineTexture = new GuiOutlineTexture(base, location);
                map.setTextureEntry(location, (TextureAtlasSprite)outlineTexture);
                partTextures.put("_internal_gui", outlineTexture);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public static String getItemLoc(String res) {
        ResourceLocation loc = new ResourceLocation(res);
        return String.format("%s:items/%s", loc.func_110624_b(), loc.func_110623_a());
    }

    public static boolean exists(String res) {
        try {
            ResourceLocation loc = new ResourceLocation(res);
            loc = new ResourceLocation(loc.func_110624_b(), "textures/" + loc.func_110623_a() + ".png");
            Minecraft.func_71410_x().func_110442_L().func_135056_b(loc);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        baseTextures.clear();
        for (Map<String, TextureAtlasSprite> map : sprites.values()) {
            map.clear();
        }
        sprites.clear();
    }

    public static ResourceLocation getTextureLocationFromToolPart(IToolPart toolpart) throws Exception {
        if (!(toolpart instanceof Item)) {
            return null;
        }
        ResourceLocation modelLocation = Util.getItemLocation((Item)toolpart);
        IModel partModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "item/parts/" + modelLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
        ResourceLocation partTexture = (ResourceLocation)partModel.getTextures().iterator().next();
        return partTexture;
    }

    public static boolean belongsToToolPart(ResourceLocation location) {
        for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
            if (!(toolpart instanceof Item)) continue;
            try {
                ResourceLocation stored;
                ResourceLocation modelLocation;
                IModel partModel;
                ResourceLocation baseTexture;
                Optional<ResourceLocation> storedResourceLocation = MaterialModelLoader.getToolPartModelLocation(toolpart);
                if (!storedResourceLocation.isPresent() || !(baseTexture = (ResourceLocation)(partModel = ModelLoaderRegistry.getModel((ResourceLocation)(modelLocation = new ResourceLocation((stored = storedResourceLocation.get()).func_110624_b(), "item/" + stored.func_110623_a())))).getTextures().iterator().next()).toString().equals(location.toString())) continue;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    static {
        guiMaterial = new MaterialGUI("_internal_gui");
        guiMaterial.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new GuiOutlineTexture(baseTexture, location);
            }
        });
    }
}

