/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.forgefixes;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OBJCustomData {
    protected static BiMap<String, Keys> keyNameMap = HashBiMap.create((int)Keys.values().length);
    protected EnumMap<Keys, Pair<Boolean, Boolean>> processUVData = Maps.newEnumMap(Keys.class);
    protected GroupConfigHandler groupConfigHandler = new GroupConfigHandler();
    protected boolean useFullAtlas = false;
    protected boolean hasProcessed = false;
    protected float[][] parsedUVBounds = new float[][]{{0.0f, 0.0f}, {1.0f, 1.0f}};

    public OBJCustomData(float[][] parsedUVBounds) {
        this.parsedUVBounds = parsedUVBounds != null ? parsedUVBounds : this.parsedUVBounds;
        OBJCustomData.initKeyNameMap();
    }

    public OBJCustomData(ImmutableMap<String, String> customData) {
        this.process(customData);
        OBJCustomData.initKeyNameMap();
    }

    public OBJCustomData duplicate() {
        OBJCustomData ret = new OBJCustomData(this.parsedUVBounds);
        ret.useFullAtlas = this.useFullAtlas;
        ret.processUVData = Maps.newEnumMap(this.processUVData);
        ret.groupConfigHandler = this.groupConfigHandler;
        ret.hasProcessed = this.hasProcessed;
        return ret;
    }

    private static void initKeyNameMap() {
        for (Keys k : Keys.values()) {
            keyNameMap.put((Object)k.key, (Object)k);
        }
    }

    public static ImmutableBiMap<String, Keys> getKeyNameMap() {
        return ImmutableBiMap.copyOf(keyNameMap);
    }

    public boolean hasUVsOutOfBounds() {
        return this.parsedUVBounds[0][0] < 0.0f || this.parsedUVBounds[0][1] < 0.0f || this.parsedUVBounds[1][0] > 1.0f || this.parsedUVBounds[1][1] > 1.0f;
    }

    public ImmutableMap<Keys, Pair<Boolean, Boolean>> getProcessUVData() {
        return ImmutableMap.copyOf(this.processUVData);
    }

    public void setGroupNameList(ImmutableList<String> groupNames) {
        this.groupConfigHandler.setGroupNameList(groupNames);
    }

    public GroupConfigHandler getConfigHandler() {
        return this.groupConfigHandler;
    }

    public GroupConfig getConfig(String configName) {
        return this.groupConfigHandler.getConfig(configName);
    }

    public OBJCustomData setUseFullAtlas(boolean useFullAtlas) {
        this.useFullAtlas = useFullAtlas;
        return this;
    }

    public void process(ImmutableMap<String, String> customData) {
        this.hasProcessed = true;
        JsonParser parser = new JsonParser();
        if (customData.containsKey((Object)Keys.FULL_ATLAS.key)) {
            this.useFullAtlas = parser.parse((String)customData.get((Object)Keys.FULL_ATLAS.key)).getAsBoolean();
        }
        this.processUVKeys(parser, customData);
        if (customData.containsKey((Object)Keys.GROUP_CONFIGURATIONS.key)) {
            this.groupConfigHandler.process(parser.parse((String)customData.get((Object)Keys.GROUP_CONFIGURATIONS.key)).getAsJsonObject());
        }
    }

    public void processUVKeys(JsonParser parser, ImmutableMap<String, String> customData) {
        for (Keys k : Keys.getProcessUVKeys()) {
            if (!customData.containsKey((Object)k.key)) continue;
            JsonPrimitive value = parser.parse((String)customData.get((Object)k.key)).getAsJsonPrimitive();
            if (value.isBoolean()) {
                this.processUVData.put(k, (Pair<Boolean, Boolean>)Pair.of((Object)value.getAsBoolean(), (Object)value.getAsBoolean()));
                continue;
            }
            if (!value.isString()) continue;
            if (value.getAsString().equals("u")) {
                this.processUVData.put(k, (Pair<Boolean, Boolean>)Pair.of((Object)true, (Object)false));
                continue;
            }
            if (!value.getAsString().equals("v")) continue;
            this.processUVData.put(k, (Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)true));
        }
        if (customData.containsKey((Object)Keys.FLIP_V.key)) {
            if (this.processUVData.containsKey((Object)Keys.FLIP_UVS)) {
                Pair<Boolean, Boolean> uvFlags = this.processUVData.get((Object)Keys.FLIP_UVS);
                this.processUVData.put(Keys.FLIP_UVS, (Pair<Boolean, Boolean>)Pair.of((Object)uvFlags.getLeft(), (Object)((Boolean)uvFlags.getRight() != false || parser.parse((String)customData.get((Object)Keys.FLIP_V.key)).getAsBoolean() ? 1 : 0)));
            } else {
                this.processUVData.put(Keys.FLIP_UVS, (Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)parser.parse((String)customData.get((Object)Keys.FLIP_V.key)).getAsBoolean()));
            }
        }
    }

    public boolean allProcessUVValuesFalse() {
        for (Map.Entry<Keys, Pair<Boolean, Boolean>> e : this.processUVData.entrySet()) {
            if (!((Boolean)e.getValue().getLeft()).booleanValue() && !((Boolean)e.getValue().getRight()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static class GroupConfig {
        public static final String DEFAULT_CONFIG_NAME = "OBJModel.Default.Config.Key";
        private String name = "OBJModel.Default.Config.Key";
        private Map<String, Boolean> visMap;
        private boolean alwaysActive = false;

        protected GroupConfig(String name, Map<String, Boolean> visMap) {
            this.name = name;
            this.visMap = visMap;
        }

        public String getName() {
            return this.name;
        }

        public ImmutableMap<String, Boolean> getVisMap() {
            return ImmutableMap.copyOf(this.visMap);
        }

        public List<String> getShownGroupNames() {
            ArrayList shownNames = Lists.newArrayList();
            for (Map.Entry<String, Boolean> e : this.visMap.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                shownNames.add(e.getKey());
            }
            return shownNames;
        }

        public List<String> getHiddenGroupNames() {
            ArrayList hiddenNames = Lists.newArrayList();
            for (Map.Entry<String, Boolean> e : this.visMap.entrySet()) {
                if (e.getValue().booleanValue()) continue;
                hiddenNames.add(e.getKey());
            }
            return hiddenNames;
        }

        public boolean getAlwaysActive() {
            return this.alwaysActive;
        }

        protected void setAlwaysActive(boolean alwaysActive) {
            this.alwaysActive = alwaysActive;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("Name: %s%n", this.name));
            builder.append("[ ");
            Iterator<Map.Entry<String, Boolean>> iterator = this.visMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Boolean> e = iterator.next();
                builder.append(String.format("%s: %b%s", e.getKey(), e.getValue(), iterator.hasNext() ? ", " : " ]"));
            }
            return builder.toString();
        }
    }

    public static class GroupConfigBuilder {
        private String name;
        private Map<String, Boolean> visMap = Maps.newHashMap();
        private boolean alwaysActive = false;

        private GroupConfigBuilder(ImmutableList<String> groupNames) {
            this.initMap(groupNames);
        }

        private void initMap(ImmutableList<String> groupNames) {
            for (String s : groupNames) {
                this.visMap.put(s, true);
            }
        }

        private void resetMap() {
            for (Map.Entry<String, Boolean> e : this.visMap.entrySet()) {
                e.setValue(true);
            }
        }

        public GroupConfigBuilder startNew(String configName) {
            this.resetMap();
            this.name = configName;
            this.alwaysActive = false;
            return this;
        }

        public GroupConfigBuilder startCombination(String combinedName) {
            return this.startNew(combinedName);
        }

        public GroupConfigBuilder startCombination(List<String> activeConfigs) {
            return this.startNew(GroupConfigBuilder.getCombinedName(activeConfigs));
        }

        public GroupConfig combine(List<String> activeConfigs, Map<String, GroupConfig> configMap, boolean ignoreHidden) {
            if (this.name == null || !this.name.startsWith("Combined_")) {
                this.startCombination(activeConfigs);
            }
            for (int i = 0; i < activeConfigs.size(); ++i) {
                String configName = activeConfigs.get(i);
                GroupConfig config = configMap.get(configName);
                String[] show = config.getShownGroupNames().toArray(new String[0]);
                String[] hide = config.getHiddenGroupNames().toArray(new String[0]);
                if (i == 0) {
                    this.hideAll(show);
                } else {
                    this.show(show).hide(ignoreHidden ? null : hide);
                }
                if (!config.getAlwaysActive()) continue;
                this.visMap.put(configName, true);
            }
            return new GroupConfig(this.name, this.visMap);
        }

        public static String getCombinedName(List<String> activeConfigs) {
            StringBuilder builder = new StringBuilder("Combined_[");
            for (String s : activeConfigs) {
                builder.append(String.format("%s,", s));
            }
            builder.deleteCharAt(builder.lastIndexOf(","));
            builder.append("]");
            return builder.toString();
        }

        public GroupConfigBuilder show(String ... names) {
            if (names == null || names[0] == null) {
                return this;
            }
            for (String name : names) {
                if (!this.visMap.containsKey(name)) continue;
                this.visMap.put(name, true);
            }
            return this;
        }

        public GroupConfigBuilder showAll(String ... except) {
            for (Map.Entry<String, Boolean> e : this.visMap.entrySet()) {
                e.setValue(!Arrays.asList(except).contains(e.getKey()));
            }
            return this;
        }

        public GroupConfigBuilder hide(String ... names) {
            if (names == null || names.length == 0 || names[0] == null) {
                return this;
            }
            for (String name : names) {
                if (!this.visMap.containsKey(name)) continue;
                this.visMap.put(name, false);
            }
            return this;
        }

        public GroupConfigBuilder hideAll(String ... except) {
            for (Map.Entry<String, Boolean> e : this.visMap.entrySet()) {
                e.setValue(Arrays.asList(except).contains(e.getKey()));
            }
            return this;
        }

        public GroupConfig build() {
            GroupConfig ret = new GroupConfig(this.name, Maps.newHashMap(this.visMap));
            ret.setAlwaysActive(this.alwaysActive);
            return ret;
        }
    }

    public static class GroupConfigHandler {
        private Map<String, GroupConfig> configMap = Maps.newHashMap();
        private Map<String, GroupConfig> combinedConfigs = Maps.newHashMap();
        private ImmutableList<String> groupNames;

        private GroupConfigHandler() {
        }

        public GroupConfigHandler duplicate() {
            GroupConfigHandler ret = new GroupConfigHandler();
            ret.configMap = Maps.newHashMap(this.configMap);
            ret.combinedConfigs = Maps.newHashMap(this.combinedConfigs);
            ret.groupNames = ImmutableList.copyOf(this.groupNames);
            return ret;
        }

        public GroupConfigBuilder getConfigBuilder() {
            return new GroupConfigBuilder(this.groupNames);
        }

        protected void setGroupNameList(ImmutableList<String> groupNames) {
            this.groupNames = groupNames;
        }

        public ImmutableList<String> getGroupNameList() {
            return this.groupNames;
        }

        public GroupConfig getConfig(String configName) {
            return this.configMap.get(configName);
        }

        public void addConfig(GroupConfig config) {
            this.configMap.put(config.name, config);
        }

        public ImmutableMap<String, GroupConfig> getConfigMap() {
            return ImmutableMap.copyOf(this.configMap);
        }

        public GroupConfig getCombinedConfig(List<String> configsToMerge, boolean ignoreHidden) {
            if (configsToMerge == null || configsToMerge.isEmpty()) {
                return null;
            }
            if (configsToMerge.size() == 1) {
                return this.configMap.get(configsToMerge.get(0));
            }
            String combinedName = GroupConfigBuilder.getCombinedName(configsToMerge);
            if (this.combinedConfigs.containsKey(combinedName)) {
                return this.combinedConfigs.get(combinedName);
            }
            GroupConfigBuilder builder = new GroupConfigBuilder(this.groupNames).startCombination(combinedName);
            GroupConfig combined = builder.combine(configsToMerge, this.configMap, ignoreHidden);
            this.combinedConfigs.put(combinedName, combined);
            return combined;
        }

        public ImmutableMap<String, GroupConfig> getCombinedConfigMap() {
            return ImmutableMap.copyOf(this.combinedConfigs);
        }

        public void process(JsonObject jsonObject) {
            GroupConfigBuilder builder = new GroupConfigBuilder(this.groupNames);
            for (Map.Entry e : jsonObject.entrySet()) {
                builder.startNew((String)e.getKey());
                JsonObject configObj = ((JsonElement)e.getValue()).getAsJsonObject();
                Object[] show = (String[])new Gson().fromJson((JsonElement)configObj.getAsJsonArray(Keys.SHOW.key), String[].class);
                Object[] hide = (String[])new Gson().fromJson((JsonElement)configObj.getAsJsonArray(Keys.HIDE.key), String[].class);
                String[] flags = (String[])new Gson().fromJson((JsonElement)configObj.getAsJsonArray(Keys.FLAGS.key), String[].class);
                if (hide == null) {
                    builder.hideAll(ArrayUtils.nullToEmpty((String[])show));
                } else if (show == null) {
                    builder.showAll((String[])hide);
                } else {
                    ArrayUtils.removeElements((Object[])show, (Object[])hide);
                    builder.hideAll((String[])show);
                }
                if (flags != null) {
                    builder.alwaysActive = Arrays.asList(flags).contains(Keys.ALWAYS_ACTIVE.key);
                }
                this.configMap.put(builder.name, builder.build());
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, GroupConfig> e : this.configMap.entrySet()) {
                builder.append(String.format("%n%s%n", e.getValue()));
            }
            return builder.toString();
        }
    }

    public static enum Keys {
        FULL_ATLAS("useFullAtlas"),
        NORMALIZE_UVS("normalizeUVs"),
        UNITIZE_UVS("unitizeUVs"),
        FLIP_UVS("flipUVs"),
        FLIP_V("flip-v"),
        GROUP_CONFIGURATIONS("groupConfigs"),
        SHOW("show"),
        HIDE("hide"),
        FLAGS("flags"),
        ALWAYS_ACTIVE("alwaysActive");

        public final String key;

        private Keys(String key) {
            this.key = key;
        }

        public static List<Keys> getCustomDataKeys() {
            return Lists.newArrayList((Object[])new Keys[]{FULL_ATLAS, GROUP_CONFIGURATIONS});
        }

        public static List<Keys> getProcessUVKeys() {
            return Lists.newArrayList((Object[])new Keys[]{NORMALIZE_UVS, UNITIZE_UVS, FLIP_UVS});
        }

        public static List<Keys> getGroupConfigurationKeys() {
            return Lists.newArrayList((Object[])new Keys[]{SHOW, HIDE, FLAGS});
        }

        public static List<Keys> getGroupConfigurationFlags() {
            return Lists.newArrayList((Object[])new Keys[]{ALWAYS_ACTIVE});
        }
    }
}

