/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.embers.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.jei.MixingRecipeWrapper;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenClass(value="mods.embers.Mixer")
public class Mixer {
    public static String name = "Embers Mixer";

    @ZenMethod
    public static void addRecipe(ILiquidStack input1, ILiquidStack input2, ILiquidStack input3, ILiquidStack input4, ILiquidStack output) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        if (input1 != null) {
            fluids.add(InputHelper.toFluid((ILiquidStack)input1));
        }
        if (input2 != null) {
            fluids.add(InputHelper.toFluid((ILiquidStack)input2));
        }
        if (input3 != null) {
            fluids.add(InputHelper.toFluid((ILiquidStack)input3));
        }
        if (input4 != null) {
            fluids.add(InputHelper.toFluid((ILiquidStack)input4));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new FluidMixingRecipe(fluids.toArray(new FluidStack[fluids.size()]), InputHelper.toFluid((ILiquidStack)output))));
    }

    @ZenMethod
    public static void remove(ILiquidStack output) {
        int i;
        ArrayList recipes = new ArrayList();
        for (i = 0; i < RecipeRegistry.mixingRecipes.size(); ++i) {
            if (!((FluidMixingRecipe)RecipeRegistry.mixingRecipes.get((int)i)).output.getFluid().getName().equals(InputHelper.toFluid((ILiquidStack)output).getFluid().getName())) continue;
            recipes.add(RecipeRegistry.mixingRecipes.get(i));
        }
        if (!recipes.isEmpty()) {
            for (i = 0; i < recipes.size(); ++i) {
                MineTweakerAPI.apply((IUndoableAction)new Remove((FluidMixingRecipe)recipes.get(i)));
            }
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<FluidMixingRecipe> {
        public Remove(FluidMixingRecipe recipe) {
            super(name, (List)RecipeRegistry.mixingRecipes);
            this.recipes.remove(recipe);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new MixingRecipeWrapper(rec)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new MixingRecipeWrapper(rec)));
        }

        protected String getRecipeInfo(FluidMixingRecipe arg0) {
            return LogHelper.getStackDescription((FluidStack)arg0.output);
        }
    }

    private static class Add
    extends BaseListAddition<FluidMixingRecipe> {
        public Add(FluidMixingRecipe recipe) {
            super(name, (List)RecipeRegistry.mixingRecipes);
            this.recipes.add(recipe);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new MixingRecipeWrapper(rec)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new MixingRecipeWrapper(rec)));
        }

        protected String getRecipeInfo(FluidMixingRecipe arg0) {
            return LogHelper.getStackDescription((FluidStack)arg0.output);
        }
    }
}

