/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.chisel.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker.mods.chisel.ChiselHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;

@ZenClass(value="mods.chisel.Groups")
public class Groups {
    @ZenMethod
    public static void addVariation(String groupName, IItemStack stack) {
        ICarvingGroup group = ChiselHelper.getGroup(groupName);
        ICarvingVariation variation = ChiselHelper.makeVariation(stack);
        if (group == null) {
            MineTweakerAPI.getLogger().logError("Cannot find group " + groupName);
            return;
        }
        if (variation == null) {
            MineTweakerAPI.getLogger().logError("Can't create variation from " + stack);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddVariation(group, variation, stack.toString()));
    }

    @ZenMethod
    public static void removeVariation(IItemStack stack) {
        ICarvingVariation variation = ChiselHelper.getVariation(stack);
        if (variation == null) {
            MineTweakerAPI.getLogger().logError("Can't find variation from " + stack);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveVariation(variation, stack.toString()));
    }

    @ZenMethod
    public static void addGroup(String groupName) {
        ICarvingGroup group = ChiselHelper.getGroup(groupName);
        if (group != null) {
            MineTweakerAPI.getLogger().logError("Group already exists " + groupName);
            return;
        }
        group = ChiselHelper.makeGroup(groupName);
        MineTweakerAPI.apply((IUndoableAction)new AddGroup(group));
    }

    @ZenMethod
    public static void removeGroup(String groupName) {
        ICarvingGroup group = ChiselHelper.getGroup(groupName);
        if (group == null) {
            MineTweakerAPI.getLogger().logError("Could not find group " + groupName);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveGroup(group));
    }

    static class RemoveGroup
    implements IUndoableAction {
        ICarvingGroup group;

        public RemoveGroup(ICarvingGroup group) {
            this.group = group;
        }

        public void apply() {
            CarvingUtils.getChiselRegistry().removeGroup(this.group.getName());
        }

        public boolean canUndo() {
            return this.group != null;
        }

        public String describe() {
            return "Removing Group: " + this.group.getName();
        }

        public String describeUndo() {
            return "Adding Group: " + this.group.getName();
        }

        public void undo() {
            CarvingUtils.getChiselRegistry().addGroup(this.group);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    static class AddGroup
    implements IUndoableAction {
        ICarvingGroup group;

        public AddGroup(ICarvingGroup group) {
            this.group = group;
        }

        public void apply() {
            CarvingUtils.getChiselRegistry().addGroup(this.group);
        }

        public boolean canUndo() {
            return this.group != null;
        }

        public String describe() {
            return "Adding Group: " + this.group.getName();
        }

        public String describeUndo() {
            return "Removing Group: " + this.group.getName();
        }

        public void undo() {
            CarvingUtils.getChiselRegistry().removeGroup(this.group.getName());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    static class RemoveVariation
    implements IUndoableAction {
        ICarvingVariation variation;
        String variationName;
        ICarvingGroup group;

        public RemoveVariation(ICarvingVariation variation, String variationName) {
            this.variation = variation;
            this.variationName = variationName;
        }

        public void apply() {
            this.group = CarvingUtils.getChiselRegistry().getGroup(this.variation.getStack());
            CarvingUtils.getChiselRegistry().removeVariation(this.variation.getBlockState(), this.group.getName());
        }

        public boolean canUndo() {
            return this.group != null && this.variation != null;
        }

        public String describe() {
            return "Removing Variation: " + this.variationName;
        }

        public String describeUndo() {
            return "Adding Variation: " + this.variationName;
        }

        public void undo() {
            CarvingUtils.getChiselRegistry().addVariation(this.group.getName(), this.variation);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    static class AddVariation
    implements IUndoableAction {
        ICarvingGroup group;
        ICarvingVariation variation;
        String variationName;

        public AddVariation(ICarvingGroup group, ICarvingVariation variation, String variationName) {
            this.group = group;
            this.variation = variation;
            this.variationName = variationName;
        }

        public void apply() {
            CarvingUtils.getChiselRegistry().addVariation(this.group.getName(), this.variation);
        }

        public boolean canUndo() {
            return this.group != null && this.variation != null;
        }

        public String describe() {
            return "Adding Variation: " + this.variationName;
        }

        public String describeUndo() {
            return "Removing Variation: " + this.variationName;
        }

        public void undo() {
            CarvingUtils.getChiselRegistry().removeVariation(this.variation.getBlockState(), this.group.getName());
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

