/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.simplegenerators.tile.generator;

import com.valkyrieofnight.simplegenerators.core.SGConfig;
import com.valkyrieofnight.simplegenerators.registry.SGRegistries;
import com.valkyrieofnight.simplegenerators.tile.TileGeneratorSingleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileEnderGen
extends TileGeneratorSingleItem {
    public TileEnderGen() {
        super(SGConfig.ender_buffer);
    }

    private int getRFT() {
        return SGConfig.ender_rft;
    }

    @Override
    public int getRFTFromItem(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int rf = SGRegistries.ENDER_GEN_FUELS.getEnergyValue(stack);
        if (rf < this.getRFT()) {
            return rf;
        }
        return this.getRFT();
    }

    @Override
    public int getDurationFromItem(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int rf = SGRegistries.ENDER_GEN_FUELS.getEnergyValue(stack);
        if (rf == 0) {
            return 0;
        }
        return rf / this.getRFTFromItem(stack);
    }

    @Override
    public boolean isValidFuel(ItemStack stack) {
        return SGRegistries.ENDER_GEN_FUELS.getEnergyValue(stack) > 0;
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.values();
    }
}

