/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.routing;

import WayofTime.bloodmagic.routing.IFluidFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class RoutingFluidFilter
implements IFluidFilter {
    protected List<FluidStack> requestList;
    protected TileEntity accessedTile;
    protected IFluidHandler fluidHandler;

    @Override
    public void initializeFilter(List<ItemStack> filteredList, TileEntity tile, IFluidHandler fluidHandler, boolean isFilterOutput) {
        this.accessedTile = tile;
        this.fluidHandler = fluidHandler;
        if (isFilterOutput) {
            IFluidTankProperties[] properties;
            this.requestList = new ArrayList<FluidStack>();
            for (ItemStack itemStack : filteredList) {
                FluidStack fluidFilterStack = RoutingFluidFilter.getFluidStackFromItemStack(itemStack);
                if (fluidFilterStack == null) continue;
                this.requestList.add(fluidFilterStack);
            }
            for (IFluidTankProperties property : properties = fluidHandler.getTankProperties()) {
                FluidStack containedStack = property.getContents();
                if (containedStack == null) continue;
                for (FluidStack fluidFilterStack : this.requestList) {
                    if (!this.doStacksMatch(fluidFilterStack, containedStack)) continue;
                    fluidFilterStack.amount = Math.max(fluidFilterStack.amount - containedStack.amount, 0);
                }
            }
        } else {
            this.requestList = new ArrayList<FluidStack>();
            IFluidTankProperties[] properties = filteredList.iterator();
            while (properties.hasNext()) {
                ItemStack itemStack = properties.next();
                FluidStack fluidFilterStack = RoutingFluidFilter.getFluidStackFromItemStack(itemStack);
                if (fluidFilterStack == null) continue;
                fluidFilterStack.amount *= -1;
                this.requestList.add(fluidFilterStack);
            }
            for (IFluidTankProperties property : properties = fluidHandler.getTankProperties()) {
                FluidStack containedStack = property.getContents();
                if (containedStack == null) continue;
                for (FluidStack fluidFilterStack : this.requestList) {
                    if (!this.doStacksMatch(fluidFilterStack, containedStack)) continue;
                    fluidFilterStack.amount += containedStack.amount;
                }
            }
        }
    }

    @Nullable
    public static FluidStack getFluidStackFromItemStack(ItemStack inputStack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)inputStack);
        if (fluidStack == null) {
            return null;
        }
        fluidStack.amount = inputStack.field_77994_a;
        return fluidStack;
    }

    @Override
    public FluidStack transferStackThroughOutputFilter(FluidStack fluidStack) {
        int allowedAmount = 0;
        for (FluidStack filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, fluidStack)) continue;
            allowedAmount = Math.min(filterStack.amount, fluidStack.amount);
            break;
        }
        if (allowedAmount <= 0) {
            return fluidStack;
        }
        FluidStack copyStack = fluidStack.copy();
        int filledAmount = this.fluidHandler.fill(fluidStack, true);
        copyStack.amount = fluidStack.amount - filledAmount;
        Iterator<FluidStack> itr = this.requestList.iterator();
        while (itr.hasNext()) {
            FluidStack filterStack = itr.next();
            if (!this.doStacksMatch(filterStack, copyStack)) continue;
            filterStack.amount -= filledAmount;
            if (filterStack.amount > 0) continue;
            itr.remove();
        }
        World world = this.accessedTile.func_145831_w();
        BlockPos pos = this.accessedTile.func_174877_v();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        return copyStack.amount <= 0 ? null : copyStack;
    }

    @Override
    public int transferThroughInputFilter(IFluidFilter outputFilter, int maxTransfer) {
        for (FluidStack filterFluidStack : this.requestList) {
            int drained;
            int allowedAmount = Math.min(filterFluidStack.amount, maxTransfer);
            if (allowedAmount <= 0) continue;
            FluidStack copyStack = filterFluidStack.copy();
            copyStack.amount = allowedAmount;
            FluidStack drainStack = this.fluidHandler.drain(copyStack, false);
            if (drainStack == null) continue;
            FluidStack remainderStack = outputFilter.transferStackThroughOutputFilter(drainStack);
            int n = drained = remainderStack == null ? copyStack.amount : copyStack.amount - remainderStack.amount;
            if (drained > 0) {
                drainStack.amount = drained;
                this.fluidHandler.drain(drainStack, true);
                maxTransfer -= drained;
            }
            Iterator<FluidStack> itr = this.requestList.iterator();
            while (itr.hasNext()) {
                FluidStack filterStack = itr.next();
                if (!this.doStacksMatch(filterStack, copyStack)) continue;
                filterStack.amount -= drained;
                if (filterStack.amount > 0) continue;
                itr.remove();
            }
            World world = this.accessedTile.func_145831_w();
            BlockPos pos = this.accessedTile.func_174877_v();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            return maxTransfer;
        }
        return 0;
    }

    @Override
    public boolean doesStackMatchFilter(FluidStack testStack) {
        for (FluidStack filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, testStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doStacksMatch(FluidStack filterStack, FluidStack testStack) {
        return testStack != null && filterStack.getFluid() == testStack.getFluid();
    }
}

