/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.mob;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityDemonBase
extends EntityCreature
implements IEntityOwnable {
    protected static final DataParameter<Byte> TAMED = EntityDataManager.func_187226_a(EntityDemonBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityDemonBase.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityDemonBase(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public void setCombatTask() {
    }

    public boolean func_70687_e(PotionEffect effect) {
        return super.func_70687_e(effect);
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.func_180431_b(source) && super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity attackedEntity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (attackedEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)attackedEntity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = attackedEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && attackedEntity instanceof EntityLivingBase) {
                ((EntityLivingBase)attackedEntity).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                attackedEntity.func_70015_d(j * 4);
            }
            if (attackedEntity instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)attackedEntity;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.func_130014_f_().func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, attackedEntity);
        }
        return flag;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.func_130014_f_().field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public boolean isStationary() {
        return false;
    }

    public boolean absorbExplosion(Explosion explosion) {
        return false;
    }

    public void performEmergencyHeal(double toHeal) {
        this.func_70691_i((float)toHeal);
        if (this.func_130014_f_() instanceof WorldServer) {
            WorldServer server = (WorldServer)this.func_130014_f_();
            server.func_175739_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 7, 0.2, 0.2, 0.2, 0.0, new int[0]);
        }
    }

    public boolean shouldEmergencyHeal() {
        return (double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5;
    }

    protected boolean func_70692_ba() {
        return !this.isTamed() && super.func_70692_ba();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.func_184753_b() == null) {
            tag.func_74778_a("OwnerUUID", "");
        } else {
            tag.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        String s = "";
        if (tag.func_150297_b("OwnerUUID", 8)) {
            s = tag.func_74779_i("OwnerUUID");
        } else {
            String s1 = tag.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
                this.setTamed(true);
            }
            catch (Throwable var4) {
                this.setTamed(false);
            }
        }
        this.setCombatTask();
    }

    public boolean shouldAttackEntity(EntityLivingBase attacker, EntityLivingBase owner) {
        if (!(attacker instanceof EntityCreeper) && !(attacker instanceof EntityGhast)) {
            IEntityOwnable entityOwnable;
            if (attacker instanceof IEntityOwnable && (entityOwnable = (IEntityOwnable)attacker).func_70902_q() == owner) {
                return false;
            }
            return !(attacker instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)attacker) || attacker instanceof EntityHorse && ((EntityHorse)attacker).func_110248_bS());
        }
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float velocity) {
    }

    public boolean isTamed() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (tamed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187562_am;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.func_130014_f_().func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void setOwner(EntityPlayer player) {
        this.setOwnerId(player.func_110124_au());
    }

    public class TargetPredicate
    implements Predicate<EntityMob> {
        EntityDemonBase entity;

        public TargetPredicate(EntityDemonBase entity) {
            this.entity = entity;
        }

        public boolean apply(EntityMob input) {
            return this.entity.shouldAttackEntity((EntityLivingBase)input, this.entity.getOwner());
        }
    }
}

