/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.util.helper;

import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.iface.IItemLPContainer;
import WayofTime.bloodmagic.api.iface.IUpgradeTrainer;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourHandler;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.item.ItemUpgradeTome;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemHelper {

    public static class LivingUpgrades {
        public static LivingArmourUpgrade getUpgrade(ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemUpgradeTome || stack.func_77973_b() instanceof IUpgradeTrainer) {
                String key = LivingUpgrades.getKey(stack);
                int level = LivingUpgrades.getLevel(stack);
                return LivingArmourHandler.generateUpgradeFromKey(key, level);
            }
            return null;
        }

        public static void setUpgrade(ItemStack stack, LivingArmourUpgrade upgrade) {
            if (stack.func_77973_b() instanceof ItemUpgradeTome || stack.func_77973_b() instanceof IUpgradeTrainer) {
                LivingUpgrades.setKey(stack, upgrade.getUniqueIdentifier());
                LivingUpgrades.setLevel(stack, upgrade.getUpgradeLevel());
            }
        }

        public static void setKey(ItemStack stack, String key) {
            if (stack.func_77973_b() instanceof ItemUpgradeTome || stack.func_77973_b() instanceof IUpgradeTrainer) {
                NBTHelper.checkNBT(stack);
                NBTTagCompound tag = stack.func_77978_p();
                tag.func_74778_a("key", key);
            }
        }

        public static String getKey(ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemUpgradeTome || stack.func_77973_b() instanceof IUpgradeTrainer) {
                NBTHelper.checkNBT(stack);
                NBTTagCompound tag = stack.func_77978_p();
                return tag.func_74779_i("key");
            }
            return "";
        }

        public static void setLevel(ItemStack stack, int level) {
            if (stack.func_77973_b() instanceof ItemUpgradeTome || stack.func_77973_b() instanceof IUpgradeTrainer) {
                NBTHelper.checkNBT(stack);
                NBTTagCompound tag = stack.func_77978_p();
                tag.func_74768_a("level", level);
            }
        }

        public static int getLevel(ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemUpgradeTome || stack.func_77973_b() instanceof IUpgradeTrainer) {
                NBTHelper.checkNBT(stack);
                NBTTagCompound tag = stack.func_77978_p();
                return tag.func_74762_e("level");
            }
            return 0;
        }
    }

    public static class LPContainer {
        public static boolean tryAndFillAltar(IBloodAltar altar, ItemStack itemStack, World world, BlockPos altarPos) {
            IItemLPContainer fillable;
            int amount;
            if (itemStack.func_77973_b() instanceof IItemLPContainer && !altar.isActive() && (amount = (fillable = (IItemLPContainer)itemStack.func_77973_b()).getStoredLP(itemStack)) > 0) {
                int filledAmount = altar.fillMainTank(amount);
                fillable.setStoredLP(itemStack, amount -= filledAmount);
                world.func_184138_a(altarPos, world.func_180495_p(altarPos), world.func_180495_p(altarPos), 3);
                return true;
            }
            return false;
        }

        public static boolean addLPToItem(ItemStack stack, int toAdd, int maxCapacity) {
            if (stack.func_77973_b() instanceof IItemLPContainer) {
                IItemLPContainer fillable = (IItemLPContainer)stack.func_77973_b();
                stack = NBTHelper.checkNBT(stack);
                if (toAdd < 0) {
                    toAdd = 0;
                }
                if (toAdd > maxCapacity) {
                    toAdd = maxCapacity;
                }
                fillable.setStoredLP(stack, Math.min(fillable.getStoredLP(stack) + toAdd, maxCapacity));
                return true;
            }
            return false;
        }
    }
}

