/*
 * Decompiled with CFR 0.152.
 */
package panda.corn.objects;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import panda.corn.other.Config;
import panda.corn.registry.ObjectList;

public class BlockCorn
extends BlockCrops
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)11);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private Block previousblock;

    public BlockCorn() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
        this.func_149647_a(null);
        this.setRegistryName("corn");
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this).setRegistryName("corn"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 11;
    }

    protected int func_185527_x(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e());
    }

    public IBlockState func_185528_e(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(age));
    }

    public boolean func_185525_y(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e()) >= this.func_185526_g();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int j = (Integer)state.func_177229_b((IProperty)AGE);
        if (j != 9 && j != 10 && j != 11 && (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this || this.func_180671_f(worldIn, pos, state)) && (worldIn.func_175623_d(pos.func_177984_a()) || j == 4 || j == 7) && worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(Config.growChance) == 1) {
            if (j == 0 || j == 1 || j == 2) {
                worldIn.func_175656_a(pos, this.func_176203_a(j + 1));
            } else if (j == 3) {
                worldIn.func_175656_a(pos, this.func_176203_a(4));
                worldIn.func_175656_a(pos.func_177984_a(), this.func_176203_a(5));
            }
            if (j == 5) {
                worldIn.func_175656_a(pos, this.func_176203_a(6));
            }
            if (j == 6) {
                worldIn.func_175656_a(pos, this.func_176203_a(7));
                worldIn.func_175656_a(pos.func_177984_a(), this.func_176203_a(8));
            }
            if (j == 8) {
                worldIn.func_175656_a(pos, this.func_176203_a(11));
                worldIn.func_175656_a(pos.func_177977_b(), this.func_176203_a(10));
                worldIn.func_175656_a(pos.func_177979_c(2), this.func_176203_a(9));
            }
            if ((j == 4 || j == 7) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this && rand.nextInt(Config.growChance * 2) == 0) {
                int k = (Integer)worldIn.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)AGE);
                if (k == 5) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176203_a(6));
                }
                if (k == 6) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176203_a(7));
                    worldIn.func_175656_a(pos.func_177981_b(2), this.func_176203_a(8));
                }
                if (k == 7) {
                    worldIn.func_175656_a(pos.func_177981_b(2), this.func_176203_a(11));
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176203_a(10));
                    worldIn.func_175656_a(pos, this.func_176203_a(9));
                }
                if (k == 8) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176203_a(11));
                    worldIn.func_175656_a(pos, this.func_176203_a(10));
                    worldIn.func_175656_a(pos.func_177977_b(), this.func_176203_a(9));
                }
            }
        }
    }

    protected Item func_149866_i() {
        return ObjectList.KERNELS;
    }

    protected Item func_149865_P() {
        return ObjectList.COB;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return false;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak || world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos)) {
            return true;
        }
        return this.func_176196_c(world, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int s = (Integer)state.func_177229_b((IProperty)AGE);
        if (s == 9 || s == 10 || s == 11) {
            return this.func_149865_P();
        }
        return this.func_149866_i();
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 9;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block.canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this) || block == this;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            this.dropcorn(world, pos, state);
            world.func_175698_g(pos.func_177984_a());
        }
        if (world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this) {
            this.dropcorn(world, pos, state);
            world.func_175698_g(pos.func_177981_b(2));
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            this.dropcorn(world, pos, state);
            world.func_175698_g(pos.func_177977_b());
        }
        if (world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == this) {
            this.dropcorn(world, pos, state);
            world.func_175698_g(pos.func_177979_c(2));
        }
    }

    private void dropcorn(World world, BlockPos pos, IBlockState state) {
        ItemStack out = new ItemStack(ObjectList.KERNELS);
        int s = (Integer)state.func_177229_b((IProperty)AGE);
        if (s == 10 || s == 11) {
            float chance = world.field_73012_v.nextFloat();
            if ((double)chance >= 0.4) {
                out = new ItemStack(ObjectList.COB, 2);
            } else if ((double)chance >= 0.1) {
                out = new ItemStack(ObjectList.COB);
            }
        }
        BlockCrops.func_180635_a((World)world, (BlockPos)pos, (ItemStack)out);
    }

    public final boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (this.func_180671_f(world, pos, state)) {
            return true;
        }
        int s = (Integer)state.func_177229_b((IProperty)AGE);
        ItemStack out = s == 9 || s == 10 || s == 11 ? ((double)world.field_73012_v.nextFloat() >= 0.4 ? new ItemStack(ObjectList.COB, 1) : new ItemStack(ObjectList.COB, 2)) : new ItemStack(ObjectList.KERNELS);
        BlockCrops.func_180635_a((World)world, (BlockPos)pos, (ItemStack)out);
        world.func_175698_g(pos);
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.func_180650_b(worldIn, pos, state, rand);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int j = (Integer)state.func_177229_b((IProperty)AGE);
        if (j > 8) {
            entityIn.field_70159_w *= 0.1;
            entityIn.field_70179_y *= 0.1;
        }
    }
}

