/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.blocks;

import java.util.Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.blocks.BlockBase;
import net.xalcon.torchmaster.common.tiles.IAutoRegisterTileEntity;
import net.xalcon.torchmaster.common.tiles.TileEntityDreadLamp;
import net.xalcon.torchmaster.common.utils.BlockUtils;

public class BlockDreadLamp
extends BlockBase
implements ITileEntityProvider,
IAutoRegisterTileEntity {
    public BlockDreadLamp() {
        super(Material.field_151578_c, "dread_lamp");
        this.func_149711_c(1.5f);
        this.func_149752_b(1.0f);
        this.func_149715_a(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDreadLamp();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityDreadLamp.class;
    }

    @Override
    public String getTileEntityRegistryName() {
        return "tile_dread_lamp";
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && TorchMasterMod.ConfigHandler.isVanillaSpawnerEnabled()) {
            long startTime = System.nanoTime();
            for (TileEntity te : worldIn.field_175730_i) {
                if (!(te instanceof TileEntityMobSpawner)) continue;
                BlockUtils.addTagToSpawner("IsSpawnerMob", (TileEntityMobSpawner)te);
            }
            long diff = System.nanoTime() - startTime;
            TorchMasterMod.Log.info("DreadLamp placed down @ " + pos + " (DIM: " + worldIn.field_73011_w.getDimension() + "); MobSpawner scan took " + diff + "ns");
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.4;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1 + 0.1, d2, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.1, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.1, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d0 + 0.1, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d0 - 0.1, 0.0, 0.0, 0.0, new int[0]);
    }
}

