/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component.traits;

import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.server.component.traits.TankWorldControl;
import li.cil.oc.server.component.traits.TankWorldControl$;
import li.cil.oc.util.ExtendedArguments;
import li.cil.oc.util.ExtendedArguments$;
import li.cil.oc.util.FluidUtils$;
import li.cil.oc.util.ResultWrapper$;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Unit$;
import scala.collection.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class TankWorldControl$class {
    @Callback(doc="function(side:number):boolean -- Compare the fluid in the selected tank with the fluid on the specified side. Returns true if equal.")
    public static Object[] compareFluid(TankWorldControl $this, Context context, Arguments args) {
        Object[] objectArray;
        EnumFacing side = $this.checkSideForAction(args, 0);
        Option<FluidStack> option = $this.fluidInTank($this.selectedTank());
        if (option instanceof Some) {
            Object[] objectArray2;
            Some some = (Some)option;
            FluidStack stack = (FluidStack)some.x();
            Option<IFluidHandler> option2 = FluidUtils$.MODULE$.fluidHandlerAt($this.position().offset(side), side.func_176734_d());
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                IFluidHandler handler = (IFluidHandler)some2.x();
                objectArray2 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)Option$.MODULE$.apply((Object)handler.getTankInfo(side.func_176734_d())).exists((Function1)new Serializable($this, stack){
                    public final FluidStack stack$1;

                    public final boolean apply(FluidTankInfo[] x$1) {
                        return Predef$.MODULE$.refArrayOps((Object[])x$1).exists((Function1)new Serializable(this){
                            private final /* synthetic */ TankWorldControl$.anonfun.compareFluid.1 $outer;

                            public final boolean apply(FluidTankInfo other) {
                                return this.$outer.stack$1.isFluidEqual(other.fluid);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.stack$1 = stack$1;
                    }
                }))}));
            } else {
                objectArray2 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false)}));
            }
            objectArray = objectArray2;
        } else {
            objectArray = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)false)}));
        }
        return objectArray;
    }

    @Callback(doc="function(side:boolean[, amount:number=1000]):boolean, number or string -- Drains the specified amount of fluid from the specified side. Returns the amount drained, or an error message.")
    public static Object[] drain(TankWorldControl $this, Context context, Arguments args) {
        Object[] objectArray;
        EnumFacing facing = $this.checkSideForAction(args, 0);
        ExtendedArguments.ExtendedArguments qual$1 = ExtendedArguments$.MODULE$.extendedArguments(args);
        int x$2 = 1;
        int x$3 = qual$1.optFluidCount$default$2();
        int count = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(qual$1.optFluidCount(x$2, x$3)), 0);
        Option<IFluidTank> option = $this.getTank($this.selectedTank());
        if (option instanceof Some) {
            Object[] objectArray2;
            Some some = (Some)option;
            IFluidTank tank = (IFluidTank)some.x();
            int space = tank.getCapacity() - tank.getFluidAmount();
            int amount = package$.MODULE$.min(count, space);
            if (count < 1 || amount > 0) {
                Object[] objectArray3;
                Option<IFluidHandler> option2 = FluidUtils$.MODULE$.fluidHandlerAt($this.position().offset(facing), facing.func_176734_d());
                if (option2 instanceof Some) {
                    Object[] objectArray4;
                    Some some2 = (Some)option2;
                    IFluidHandler handler = (IFluidHandler)some2.x();
                    FluidStack fluidStack = tank.getFluid();
                    if (fluidStack != null) {
                        Object[] objectArray5;
                        FluidStack fluidStack2 = fluidStack;
                        FluidStack drained = handler.drain(facing.func_176734_d(), new FluidStack(fluidStack2, amount), true);
                        if (drained != null && drained.amount > 0 || amount == 0) {
                            int filled = tank.fill(drained, true);
                            objectArray5 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)filled)}));
                        } else {
                            objectArray5 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible or no fluid"}));
                        }
                        objectArray4 = objectArray5;
                    } else {
                        int transferred = tank.fill(handler.drain(facing.func_176734_d(), amount, true), true);
                        objectArray4 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((transferred > 0 ? 1 : 0) != 0), BoxesRunTime.boxToInteger((int)transferred)}));
                    }
                    objectArray3 = objectArray4;
                } else {
                    objectArray3 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible or no fluid"}));
                }
                objectArray2 = objectArray3;
            } else {
                objectArray2 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "tank is full"}));
            }
            objectArray = objectArray2;
        } else {
            objectArray = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no tank selected"}));
        }
        return objectArray;
    }

    @Callback(doc="function(side:number[, amount:number=1000]):boolean, number of string -- Eject the specified amount of fluid to the specified side. Returns the amount ejected or an error message.")
    public static Object[] fill(TankWorldControl $this, Context context, Arguments args) {
        Object[] objectArray;
        EnumFacing facing = $this.checkSideForAction(args, 0);
        ExtendedArguments.ExtendedArguments qual$2 = ExtendedArguments$.MODULE$.extendedArguments(args);
        int x$4 = 1;
        int x$5 = qual$2.optFluidCount$default$2();
        int count = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(qual$2.optFluidCount(x$4, x$5)), 0);
        Option<IFluidTank> option = $this.getTank($this.selectedTank());
        if (option instanceof Some) {
            Object[] objectArray2;
            Some some = (Some)option;
            IFluidTank tank = (IFluidTank)some.x();
            int amount = package$.MODULE$.min(count, tank.getFluidAmount());
            if (count < 1 || amount > 0) {
                Object[] objectArray3;
                Option<IFluidHandler> option2 = FluidUtils$.MODULE$.fluidHandlerAt($this.position().offset(facing), facing.func_176734_d());
                if (option2 instanceof Some) {
                    Object[] objectArray4;
                    Some some2 = (Some)option2;
                    IFluidHandler handler = (IFluidHandler)some2.x();
                    FluidStack fluidStack = tank.getFluid();
                    if (fluidStack != null) {
                        Object[] objectArray5;
                        FluidStack fluidStack2 = fluidStack;
                        int filled = handler.fill(facing.func_176734_d(), new FluidStack(fluidStack2, amount), true);
                        if (filled > 0 || amount == 0) {
                            tank.drain(filled, true);
                            objectArray5 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)filled)}));
                        } else {
                            objectArray5 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible or no fluid"}));
                        }
                        objectArray4 = objectArray5;
                    } else {
                        objectArray4 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "tank is empty"}));
                    }
                    objectArray3 = objectArray4;
                } else {
                    objectArray3 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no space"}));
                }
                objectArray2 = objectArray3;
            } else {
                objectArray2 = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "tank is empty"}));
            }
            objectArray = objectArray2;
        } else {
            objectArray = ResultWrapper$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no tank selected"}));
        }
        return objectArray;
    }

    public static void $init$(TankWorldControl $this) {
    }
}

