/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcjty.lib.compat.CompatBlock;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.config.DimletRules;
import mcjty.rftoolsdim.config.Filter;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class DimletDebug {
    public static void dumpLiquids() {
        FluidRegistry.getRegisteredFluids().entrySet().stream().forEach(DimletDebug::dumpLiquid);
    }

    private static void dumpLiquid(Map.Entry<String, Fluid> entry) {
        Block block = entry.getValue().getBlock();
        if (block != null) {
            ResourceLocation nameForObject = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
            String mod = nameForObject.func_110624_b();
            DimletKey key = new DimletKey(DimletType.DIMLET_LIQUID, block.getRegistryName() + "@0");
            Settings settings = DimletRules.getSettings(key, mod);
            Logging.log((String)(key + ": " + settings.toString()));
        }
    }

    public static void dumpBlocks() {
        Block.field_149771_c.forEach(DimletDebug::dumpBlock);
    }

    private static void dumpBlock(Block block) {
        if (block instanceof BlockLiquid) {
            return;
        }
        Set<Filter.Feature> features = KnownDimletConfiguration.getBlockFeatures(block);
        String mod = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).func_110624_b();
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            int meta = state.func_177230_c().func_176201_c(state);
            ArrayList propertyNames = new ArrayList(CompatBlock.getPropertyKeys((IBlockState)state));
            propertyNames.sort((o1, o2) -> o1.func_177701_a().compareTo(o2.func_177701_a()));
            ImmutableMap properties = state.func_177228_b();
            HashMap<String, String> props = new HashMap<String, String>();
            for (Map.Entry entry : properties.entrySet()) {
                props.put(((IProperty)entry.getKey()).func_177701_a(), ((Comparable)entry.getValue()).toString());
            }
            DimletKey key = new DimletKey(DimletType.DIMLET_MATERIAL, block.getRegistryName() + "@" + meta);
            Settings settings = DimletRules.getSettings(key, mod, features, props);
            Logging.log((String)(key + " (" + state.toString() + "): " + settings.toString()));
        }
    }

    public static void dumpDimlets() {
        Map<DimletKey, Settings> knownDimlets = KnownDimletConfiguration.getKnownDimlets();
        ArrayList<DimletKey> keys = new ArrayList<DimletKey>(knownDimlets.keySet());
        keys.sort((o1, o2) -> {
            int i = o1.getType().compareTo(o2.getType());
            if (i != 0) {
                return i;
            }
            if (o1.getId() != null && o2.getId() != null) {
                return o1.getId().compareTo(o2.getId());
            }
            if (o1.getId() == null && o2.getId() == null) {
                return 0;
            }
            if (o1.getId() == null) {
                return -1;
            }
            return 1;
        });
        for (DimletKey key : keys) {
            Settings value = knownDimlets.get(key);
            Logging.log((String)(key + ": " + value));
        }
    }
}

