/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap.generators;

import com.google.common.base.Strings;
import java.io.File;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.lex.yunomakegoodmap.StructureUtil;
import net.minecraftforge.lex.yunomakegoodmap.generators.IPlatformGenerator;

public class StructureLoader
implements IPlatformGenerator {
    private String fileName;

    public StructureLoader(File baseDir, String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void generate(World world, BlockPos pos) {
        PlacementSettings settings = new PlacementSettings();
        Template temp = null;
        String suffix = world.field_73011_w.func_186058_p().func_186067_c();
        String opts = world.func_72912_H().func_82571_y() + suffix;
        if (!Strings.isNullOrEmpty((String)opts)) {
            temp = StructureUtil.loadTemplate(new ResourceLocation(opts), (WorldServer)world, true);
        }
        if (temp == null) {
            temp = StructureUtil.loadTemplate(new ResourceLocation("/config/", this.fileName + suffix), (WorldServer)world, !Strings.isNullOrEmpty((String)suffix));
        }
        if (temp == null) {
            return;
        }
        BlockPos spawn = StructureUtil.findSpawn(temp, settings);
        if (spawn != null) {
            pos = pos.func_177973_b((Vec3i)spawn);
            world.func_175652_B(pos);
        }
        temp.func_189962_a(world, pos, settings, 0);
        world.func_175712_a(new StructureBoundingBox((Vec3i)pos, (Vec3i)pos.func_177971_a((Vec3i)temp.func_186259_a())), true);
    }
}

