/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.util.helpers;

import com.google.common.collect.Maps;
import com.valkyrieofnight.valkyrielib.item.crafting.ShapedPotionRecipe;
import com.valkyrieofnight.valkyrielib.util.helpers.StringHelper;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    public static void addShapedRecipe(ItemStack output, Object ... input) {
        Object[] obj = input;
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])obj);
    }

    public static void addShapedPotionRecipe(ItemStack output, Object ... recipeComponents) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = null;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            map.put(character, itemstack);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            aitemstack[l] = map.containsKey(Character.valueOf(c0)) ? ((ItemStack)map.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedPotionRecipe shapedrecipes = new ShapedPotionRecipe(j, k, aitemstack, output);
        if (shapedrecipes != null) {
            GameRegistry.addRecipe((IRecipe)shapedrecipes);
        }
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        Object[] obj = input;
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])obj);
    }

    public static void addShapelessRecipeOD(ItemStack output, Object ... input) {
        Object[] obj = input;
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, obj));
    }

    @Deprecated
    public static void addShaplessRecipe(ItemStack output, Object ... input) {
        RecipeHelper.addShapelessRecipe(output, input);
    }

    public static void add1x1VR(ItemStack input, ItemStack output) {
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"X", Character.valueOf('X'), input});
    }

    public static void add1x1OD(String input, ItemStack output) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"X", Character.valueOf('X'), input}));
    }

    public static void add2x2VR(ItemStack input, ItemStack output) {
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), input});
    }

    public static void add2x2OD(String input, ItemStack output) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"XX", "XX", Character.valueOf('X'), input}));
    }

    public static void add3x3VR(ItemStack input, ItemStack output) {
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), input});
    }

    public static void add3x3OD(String input, ItemStack output) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), input}));
    }

    public static void addIN(String material, Item ingot, Item nugget) {
        String mat = StringHelper.toTitleCase(material);
        RecipeHelper.add3x3OD("ingot" + mat, new ItemStack(nugget, 9));
        RecipeHelper.add3x3OD("nugget" + mat, new ItemStack(ingot, 1));
    }

    public static void addINB(String material, Item nugget, Item ingot, Block block) {
        String mat = StringHelper.toTitleCase(material);
        RecipeHelper.add3x3OD("nugget" + mat, new ItemStack(ingot, 1));
        RecipeHelper.add1x1OD("ingot" + mat, new ItemStack(nugget, 9));
        RecipeHelper.add3x3OD("ingot" + mat, new ItemStack(block, 1));
        RecipeHelper.add1x1OD("block" + mat, new ItemStack(ingot, 9));
    }

    public static void addGear(String teethMaterial, String shaftMaterial, ItemStack output) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{" T ", "TST", " T ", Character.valueOf('T'), teethMaterial, Character.valueOf('S'), shaftMaterial}));
    }

    public static void addPlate3x1(String input, ItemStack output) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"III", Character.valueOf('I'), input}));
    }

    public static void addPlate2x1(String input, ItemStack output) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"II", Character.valueOf('I'), input}));
    }

    public static void addFurnaceRecipe(ItemStack input, ItemStack output, float exp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)exp);
    }

    public static void addPlate2x2(String input, ItemStack output) {
        RecipeHelper.add2x2OD(input, output);
    }

    public static void addMetalINB(Item nugget, Item ingot, Block block) {
        RecipeHelper.addMetalIN(nugget, ingot);
        RecipeHelper.addMetalIB(ingot, block);
    }

    public static void addStairsRecipe(ItemStack input, ItemStack output) {
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), input});
    }

    public static void addSlabsRecipe(ItemStack input, ItemStack output) {
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"XXX", Character.valueOf('X'), input});
    }

    public static void addSlabsToBlockRecipe(ItemStack slab, ItemStack block) {
        RecipeHelper.addShaplessRecipe(block, slab, slab);
    }

    public static void addMetalIN(Item nugget, Item ingot) {
        RecipeHelper.add3x3VR(new ItemStack(nugget, 1), new ItemStack(ingot, 1));
        RecipeHelper.add1x1VR(new ItemStack(ingot, 1), new ItemStack(nugget, 9));
    }

    public static void addMetalIB(Item ingot, Block block) {
        RecipeHelper.add3x3VR(new ItemStack(ingot), new ItemStack(block, 1));
        RecipeHelper.add1x1VR(new ItemStack(block), new ItemStack(ingot, 9));
    }
}

