/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.autopackager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.mcupdater.autopackager.AutoPackager;
import org.mcupdater.autopackager.helpers.InventoryHelper;

@Optional.Interface(iface="com.dynious.refinedrelocation.api.tileentity.ISortingMember", modid="RefinedRelocation")
public class TilePackager
extends TileEntity
implements ITickable {
    private EnergyStorage storage = new EnergyStorage(AutoPackager.energyPerCycle * 100);
    private EnumFacing orientation = EnumFacing.DOWN;
    private int tickCounter = 0;
    private int tickDelay = AutoPackager.delayCycleNormal;
    protected Mode mode = Mode.HYBRID;

    public void func_73660_a() {
        if (++this.tickCounter >= this.tickDelay) {
            this.tickCounter = 0;
            if (this.storage.getEnergyStored() > AutoPackager.energyPerCycle) {
                if (this.tryCraft()) {
                    this.storage.extractEnergy(AutoPackager.energyPerCycle, false);
                    this.tickDelay = AutoPackager.delayCycleNormal;
                } else {
                    this.tickDelay = AutoPackager.delayCycleIdle;
                }
            }
        }
    }

    private boolean tryCraft() {
        if (this.orientation == null) {
            return false;
        }
        BlockPos inputPos = this.getInputSide();
        BlockPos outputPos = this.getOutputSide();
        TileEntity tileInput = this.field_145850_b.func_175625_s(inputPos);
        TileEntity tileOutput = this.field_145850_b.func_175625_s(outputPos);
        HashMap slotMap = new HashMap();
        if (tileInput instanceof IInventory && tileOutput instanceof IInventory) {
            InvWrapper invInput = new InvWrapper((IInventory)tileInput);
            InvWrapper invOutput = new InvWrapper((IInventory)tileOutput);
            for (int slot = 0; slot < invInput.getSlots(); ++slot) {
                boolean result;
                if (invInput.getStackInSlot(slot) == null || invInput instanceof ISidedInventory && !((ISidedInventory)invInput).func_180461_b(slot, invInput.getStackInSlot(slot), EnumFacing.DOWN)) continue;
                if (slotMap.containsKey(invInput.getStackInSlot(slot).func_77977_a() + ":" + invInput.getStackInSlot(slot).func_77952_i())) {
                    ((SortedSet)slotMap.get(invInput.getStackInSlot(slot).func_77977_a() + ":" + invInput.getStackInSlot(slot).func_77952_i())).add(slot);
                } else {
                    TreeSet<Integer> slotList = new TreeSet<Integer>();
                    slotList.add(slot);
                    slotMap.put(invInput.getStackInSlot(slot).func_77977_a() + ":" + invInput.getStackInSlot(slot).func_77952_i(), slotList);
                }
                switch (this.mode) {
                    case HYBRID: {
                        result = this.craftSmall(invInput, invOutput, slot) || this.craftLarge(invInput, invOutput, slot);
                        break;
                    }
                    case SMALL: {
                        result = this.craftSmall(invInput, invOutput, slot);
                        break;
                    }
                    case LARGE: {
                        result = this.craftLarge(invInput, invOutput, slot);
                        break;
                    }
                    case HOLLOW: {
                        result = this.craftHollow(invInput, invOutput, slot);
                        break;
                    }
                    case UNPACKAGE: {
                        result = this.craftTiny(invInput, invOutput, slot);
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                if (!result) continue;
                return true;
            }
            for (Map.Entry entry : slotMap.entrySet()) {
                if (((SortedSet)entry.getValue()).size() <= 1) continue;
                SortedSet slots = (SortedSet)entry.getValue();
                while (slots.size() > 1) {
                    if (invInput.getStackInSlot(((Integer)slots.first()).intValue()) == null || !(invInput.getStackInSlot(((Integer)slots.first()).intValue()).func_77977_a() + ":" + invInput.getStackInSlot(((Integer)slots.first()).intValue()).func_77952_i()).equals(entry.getKey()) || invInput.getStackInSlot((int)((Integer)slots.first()).intValue()).field_77994_a >= invInput.getStackInSlot(((Integer)slots.first()).intValue()).func_77976_d()) {
                        slots.remove(slots.first());
                        continue;
                    }
                    if (invInput.getStackInSlot(((Integer)slots.last()).intValue()) == null || !invInput.getStackInSlot(((Integer)slots.last()).intValue()).func_77969_a(invInput.getStackInSlot(((Integer)slots.first()).intValue())) || !ItemStack.func_77970_a((ItemStack)invInput.getStackInSlot(((Integer)slots.first()).intValue()), (ItemStack)invInput.getStackInSlot(((Integer)slots.last()).intValue()))) {
                        slots.remove(slots.last());
                        continue;
                    }
                    if (invInput.getStackInSlot((int)((Integer)slots.first()).intValue()).field_77994_a + invInput.getStackInSlot((int)((Integer)slots.last()).intValue()).field_77994_a <= invInput.getStackInSlot(((Integer)slots.first()).intValue()).func_77976_d()) {
                        invInput.getStackInSlot((int)((Integer)slots.first()).intValue()).field_77994_a += invInput.getStackInSlot((int)((Integer)slots.last()).intValue()).field_77994_a;
                        invInput.setStackInSlot(((Integer)slots.last()).intValue(), null);
                        continue;
                    }
                    int spaceRemain = invInput.getStackInSlot(((Integer)slots.first()).intValue()).func_77976_d() - invInput.getStackInSlot((int)((Integer)slots.first()).intValue()).field_77994_a;
                    invInput.getStackInSlot((int)((Integer)slots.first()).intValue()).field_77994_a += spaceRemain;
                    invInput.getStackInSlot((int)((Integer)slots.last()).intValue()).field_77994_a -= spaceRemain;
                }
            }
        }
        return false;
    }

    private boolean craftTiny(InvWrapper invInput, InvWrapper invOutput, int slot) {
        if (invInput.getStackInSlot((int)slot).field_77994_a >= 1) {
            ItemStack result;
            ItemStack testStack = invInput.getStackInSlot(slot).func_77946_l();
            testStack.field_77994_a = 1;
            if (!AutoPackager.single.containsKey(testStack)) {
                InventoryCrafting smallCraft = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer entityPlayer) {
                        return false;
                    }
                }, 2, 2);
                smallCraft.func_70299_a(0, testStack);
                result = CraftingManager.func_77594_a().func_82787_a(smallCraft, this.field_145850_b);
                AutoPackager.single.put(testStack, result);
            } else {
                result = AutoPackager.single.get(testStack);
            }
            if (result != null && InventoryHelper.canStackFitInInventory(invOutput, result)) {
                invInput.extractItem(slot, 1, false);
                InventoryHelper.insertItemStackIntoInventory(invOutput, result);
                return true;
            }
        }
        return false;
    }

    private boolean craftHollow(InvWrapper invInput, InvWrapper invOutput, int slot) {
        if (invInput.getStackInSlot((int)slot).field_77994_a >= 8) {
            ItemStack result;
            ItemStack testStack = invInput.getStackInSlot(slot).func_77946_l();
            testStack.field_77994_a = 1;
            if (!AutoPackager.hollow.containsKey(testStack)) {
                InventoryCrafting largeCraft = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer entityPlayer) {
                        return false;
                    }
                }, 3, 3);
                for (int craftSlot = 0; craftSlot < 9; ++craftSlot) {
                    largeCraft.func_70299_a(craftSlot, craftSlot == 4 ? null : testStack);
                }
                result = CraftingManager.func_77594_a().func_82787_a(largeCraft, this.field_145850_b);
                AutoPackager.hollow.put(testStack, result);
            } else {
                result = AutoPackager.hollow.get(testStack);
            }
            if (result != null && InventoryHelper.canStackFitInInventory(invOutput, result)) {
                invInput.extractItem(slot, 8, false);
                InventoryHelper.insertItemStackIntoInventory(invOutput, result);
                return true;
            }
        }
        return false;
    }

    private boolean craftLarge(InvWrapper invInput, InvWrapper invOutput, int slot) {
        if (invInput.getStackInSlot((int)slot).field_77994_a >= 9) {
            ItemStack result;
            ItemStack testStack = invInput.getStackInSlot(slot).func_77946_l();
            testStack.field_77994_a = 1;
            if (!AutoPackager.large.containsKey(testStack)) {
                InventoryCrafting largeCraft = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer entityPlayer) {
                        return false;
                    }
                }, 3, 3);
                for (int craftSlot = 0; craftSlot < 9; ++craftSlot) {
                    largeCraft.func_70299_a(craftSlot, testStack);
                }
                result = CraftingManager.func_77594_a().func_82787_a(largeCraft, this.field_145850_b);
                AutoPackager.large.put(testStack, result);
            } else {
                result = AutoPackager.large.get(testStack);
            }
            if (result != null && InventoryHelper.canStackFitInInventory(invOutput, result)) {
                invInput.extractItem(slot, 9, false);
                InventoryHelper.insertItemStackIntoInventory(invOutput, result);
                return true;
            }
        }
        return false;
    }

    private boolean craftSmall(InvWrapper invInput, InvWrapper invOutput, int slot) {
        if (invInput.getStackInSlot((int)slot).field_77994_a >= 4) {
            ItemStack result;
            ItemStack testStack = invInput.getStackInSlot(slot).func_77946_l();
            testStack.field_77994_a = 1;
            if (!AutoPackager.small.containsKey(testStack)) {
                InventoryCrafting smallCraft = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer entityPlayer) {
                        return false;
                    }
                }, 2, 2);
                for (int craftSlot = 0; craftSlot < 4; ++craftSlot) {
                    smallCraft.func_70299_a(craftSlot, testStack);
                }
                result = CraftingManager.func_77594_a().func_82787_a(smallCraft, this.field_145850_b);
                AutoPackager.small.put(testStack, result);
            } else {
                result = AutoPackager.small.get(testStack);
            }
            if (result != null && InventoryHelper.canStackFitInInventory(invOutput, result)) {
                invInput.extractItem(slot, 4, false);
                InventoryHelper.insertItemStackIntoInventory(invOutput, result);
                return true;
            }
        }
        return false;
    }

    private BlockPos getInputSide() {
        switch (this.orientation) {
            case NORTH: {
                return this.field_174879_c.func_177974_f();
            }
            case EAST: {
                return this.field_174879_c.func_177968_d();
            }
            case SOUTH: {
                return this.field_174879_c.func_177976_e();
            }
            case WEST: {
                return this.field_174879_c.func_177978_c();
            }
        }
        return this.field_174879_c.func_177978_c();
    }

    private BlockPos getOutputSide() {
        switch (this.orientation) {
            case NORTH: {
                return this.field_174879_c.func_177976_e();
            }
            case EAST: {
                return this.field_174879_c.func_177978_c();
            }
            case SOUTH: {
                return this.field_174879_c.func_177974_f();
            }
            case WEST: {
                return this.field_174879_c.func_177968_d();
            }
        }
        return this.field_174879_c.func_177968_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("mode", this.mode.ordinal());
        tagCompound.func_74778_a("orientation", this.orientation.func_176610_l());
        tagCompound.func_74768_a("energy", this.storage.getEnergyStored());
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.mode = Mode.values()[tagCompound.func_74762_e("mode")];
        this.orientation = EnumFacing.func_176739_a((String)tagCompound.func_74779_i("orientation"));
        if (tagCompound.func_74764_b("energy")) {
            this.storage.receiveEnergy(tagCompound.func_74762_e("energy"), false);
        }
    }

    public void setOrientation(EnumFacing orientation) {
        this.orientation = orientation;
    }

    public void cycleMode(EntityPlayer player) {
        this.mode = Mode.values()[(this.mode.ordinal() + 1) % Mode.values().length];
        if (!this.field_145850_b.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(new TextComponentTranslation("autopackager.mode.current", new Object[0]).func_150261_e() + " " + new TextComponentTranslation(this.mode.getMessage(), new Object[0]).func_150261_e(), new Object[0]));
        }
    }

    public void checkMode(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(new TextComponentTranslation("autopackager.mode.current", new Object[0]).func_150261_e() + " " + new TextComponentTranslation(this.mode.getMessage(), new Object[0]).func_150261_e(), new Object[0]));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager netman, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        if (this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addWailaInformation(List information) {
        information.add(new TextComponentTranslation("autopackager.mode.current", new Object[0]).func_150261_e() + " " + new TextComponentTranslation(this.mode.getMessage(), new Object[0]).func_150261_e());
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    protected static enum Mode {
        HYBRID("autopackager.mode.hybrid"),
        SMALL("autopackager.mode.small"),
        LARGE("autopackager.mode.large"),
        HOLLOW("autopackager.mode.hollow"),
        UNPACKAGE("autopackager.mode.unpackage");

        private String message;

        private Mode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

