/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.variations.vanilla;

import com.github.atomicblom.shearmadness.api.IBehaviourRegistry;
import com.github.atomicblom.shearmadness.api.ItemStackHelper;
import com.github.atomicblom.shearmadness.api.behaviour.DamageBehaviour;
import com.github.atomicblom.shearmadness.api.behaviour.ExplosiveBehaviour;
import com.github.atomicblom.shearmadness.api.behaviour.PlaceInvisibleBlockBehaviour;
import com.github.atomicblom.shearmadness.api.events.RegisterShearMadnessBehaviourEvent;
import com.github.atomicblom.shearmadness.api.events.ShearMadnessSheepKilledEvent;
import com.github.atomicblom.shearmadness.configuration.Settings;
import com.github.atomicblom.shearmadness.utility.BlockLibrary;
import com.github.atomicblom.shearmadness.variations.vanilla.behaviour.FollowAutoCraftItems;
import com.github.atomicblom.shearmadness.variations.vanilla.behaviour.NoteBlockBehaviour;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class VanillaBehaviours {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Optional.Method(modid="shearmadness")
    public static void onShearMadnessRegisterBehaviours(RegisterShearMadnessBehaviourEvent event) {
        IBehaviourRegistry registry = event.getRegistry();
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, (Block)Blocks.field_150434_aF), entity -> new DamageBehaviour((EntitySheep)entity, Settings.Behaviours::allowCactus, DamageSource.field_76367_g));
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, Blocks.field_189877_df), entity -> new DamageBehaviour((EntitySheep)entity, Settings.Behaviours::allowFireDamage, DamageSource.field_190095_e));
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, Blocks.field_150451_bX), entity -> new PlaceInvisibleBlockBehaviour((EntitySheep)entity, Settings.Behaviours::allowRedstone, BlockLibrary.invisibleRedstone.func_176223_P()));
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, Blocks.field_150426_aN), entity -> new PlaceInvisibleBlockBehaviour((EntitySheep)entity, Settings.Behaviours::allowGlowstone, BlockLibrary.invisibleGlowstone.func_176223_P()));
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, Blocks.field_150342_X), entity -> new PlaceInvisibleBlockBehaviour((EntitySheep)entity, Settings.Behaviours::allowBookshelf, BlockLibrary.invisibleBookshelf.func_176223_P()));
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, Blocks.field_150335_W), sheep -> new ExplosiveBehaviour((EntitySheep)sheep, Settings.Behaviours::allowTNT));
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, Blocks.field_150323_B), sheep -> new NoteBlockBehaviour((EntitySheep)sheep, () -> true));
        registry.registerBehaviour(itemStack -> ItemStackHelper.isStackForBlock(itemStack, Blocks.field_150462_ai), sheep -> new FollowAutoCraftItems((EntitySheep)sheep));
    }

    @SubscribeEvent
    public static void onSheepKilled(ShearMadnessSheepKilledEvent event) {
        if (ItemStackHelper.isStackForBlock(event.getChiselItemStack(), Blocks.field_150335_W) && event.getSource().func_94541_c()) {
            event.noDrops();
        }
    }
}

